/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.yarn.configuration;

import java.io.File;
import java.util.Optional;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.util.Preconditions;
import org.apache.flink.yarn.configuration.YarnConfigOptionsInternal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class YarnLogConfigUtil {
    private static final Logger LOG = LoggerFactory.getLogger(YarnLogConfigUtil.class);
    public static final String CONFIG_FILE_LOGBACK_NAME = "logback.xml";
    public static final String CONFIG_FILE_LOG4J_NAME = "log4j.properties";

    @VisibleForTesting
    public static Configuration setLogConfigFileInConfig(Configuration configuration, String configurationDirectory) {
        if (configuration.get(YarnConfigOptionsInternal.APPLICATION_LOG_CONFIG_FILE) != null) {
            return configuration;
        }
        YarnLogConfigUtil.discoverLogConfigFile(configurationDirectory).ifPresent(file -> configuration.set(YarnConfigOptionsInternal.APPLICATION_LOG_CONFIG_FILE, (Object)file.getPath()));
        return configuration;
    }

    private static Optional<File> discoverLogConfigFile(String configurationDirectory) {
        File logbackFile;
        Optional<Object> logConfigFile = Optional.empty();
        File log4jFile = new File(configurationDirectory + File.separator + CONFIG_FILE_LOG4J_NAME);
        if (log4jFile.exists()) {
            logConfigFile = Optional.of(log4jFile);
        }
        if ((logbackFile = new File(configurationDirectory + File.separator + CONFIG_FILE_LOGBACK_NAME)).exists()) {
            if (logConfigFile.isPresent()) {
                LOG.warn("The configuration directory ('" + configurationDirectory + "') already contains a LOG4J config file.If you want to use logback, then please delete or rename the log configuration file.");
            } else {
                logConfigFile = Optional.of(logbackFile);
            }
        }
        return logConfigFile;
    }

    public static String getLoggingYarnCommand(Configuration configuration) {
        Preconditions.checkNotNull((Object)configuration);
        String logConfigFilePath = (String)configuration.get(YarnConfigOptionsInternal.APPLICATION_LOG_CONFIG_FILE);
        if (logConfigFilePath == null) {
            return "";
        }
        String logCommand = YarnLogConfigUtil.getLog4jCommand(logConfigFilePath);
        if (logCommand.isEmpty()) {
            logCommand = YarnLogConfigUtil.getLogBackCommand(logConfigFilePath);
        }
        return logCommand;
    }

    private static String getLogBackCommand(String logConfigFilePath) {
        boolean hasLogback = logConfigFilePath.endsWith(CONFIG_FILE_LOGBACK_NAME);
        if (!hasLogback) {
            return "";
        }
        return "-Dlog.file=\"<LOG_DIR>/jobmanager.log\"" + " -Dlogback.configurationFile=file:logback.xml";
    }

    private static String getLog4jCommand(String logConfigFilePath) {
        boolean hasLog4j = logConfigFilePath.endsWith(CONFIG_FILE_LOG4J_NAME);
        if (!hasLog4j) {
            return "";
        }
        return "-Dlog.file=\"<LOG_DIR>/jobmanager.log\"" + " -Dlog4j.configuration=file:log4j.properties" + " -Dlog4j.configurationFile=file:log4j.properties";
    }
}

