/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.flink.api.java.tuple.Tuple;
import org.apache.flink.util.IOUtils;
import org.apache.flink.util.Preconditions;
import org.junit.Assert;

public class TestBaseUtils {
    public static BufferedReader[] getResultReader(String resultPath) throws IOException {
        return TestBaseUtils.getResultReader(resultPath, new String[0], false);
    }

    private static BufferedReader[] getResultReader(String resultPath, String[] excludePrefixes, boolean inOrderOfFiles) throws IOException {
        File[] files = TestBaseUtils.getAllInvolvedFiles(resultPath, excludePrefixes);
        if (inOrderOfFiles) {
            Arrays.sort(files, new Comparator<File>(){

                @Override
                public int compare(File o1, File o2) {
                    try {
                        int f1 = Integer.parseInt(o1.getName());
                        int f2 = Integer.parseInt(o2.getName());
                        return f1 < f2 ? -1 : (f1 > f2 ? 1 : 0);
                    }
                    catch (NumberFormatException e) {
                        throw new RuntimeException("The file names are no numbers and cannot be ordered: " + o1.getName() + "/" + o2.getName());
                    }
                }
            });
        }
        BufferedReader[] readers = new BufferedReader[files.length];
        for (int i = 0; i < files.length; ++i) {
            readers[i] = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(files[i]), StandardCharsets.UTF_8));
        }
        return readers;
    }

    public static void readAllResultLines(List<String> target, String resultPath) throws IOException {
        TestBaseUtils.readAllResultLines(target, resultPath, new String[0], false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void readAllResultLines(List<String> target, String resultPath, String[] excludePrefixes, boolean inOrderOfFiles) throws IOException {
        Preconditions.checkArgument((resultPath != null ? 1 : 0) != 0, (Object)"resultPath cannot be be null");
        BufferedReader[] readers = TestBaseUtils.getResultReader(resultPath, excludePrefixes, inOrderOfFiles);
        try {
            for (BufferedReader reader : readers) {
                String s;
                while ((s = reader.readLine()) != null) {
                    target.add(s);
                }
            }
        }
        finally {
            for (BufferedReader reader : readers) {
                IOUtils.closeQuietly((AutoCloseable)reader);
            }
        }
    }

    public static void compareResultsByLinesInMemory(String expectedResultStr, String resultPath) throws Exception {
        TestBaseUtils.compareResultsByLinesInMemory(expectedResultStr, resultPath, new String[0]);
    }

    public static void compareResultsByLinesInMemory(String expectedResultStr, String resultPath, String[] excludePrefixes) throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        TestBaseUtils.readAllResultLines(list, resultPath, excludePrefixes, false);
        Object[] result = list.toArray(new String[list.size()]);
        Arrays.sort(result);
        Object[] expected = expectedResultStr.isEmpty() ? new String[]{} : expectedResultStr.split("\n");
        Arrays.sort(expected);
        if (expected.length != result.length || !Arrays.deepEquals(expected, result)) {
            String msg = String.format("Different elements in arrays: expected %d elements and received %d\nfiles: %s\n expected: %s\n received: %s", expected.length, result.length, Arrays.toString(TestBaseUtils.getAllInvolvedFiles(resultPath, excludePrefixes)), Arrays.toString(expected), Arrays.toString(result));
            Assert.fail((String)msg);
        }
    }

    public static void compareResultsByLinesInMemoryWithStrictOrder(String expectedResultStr, String resultPath) throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        TestBaseUtils.readAllResultLines(list, resultPath, new String[0], true);
        Object[] result = list.toArray(new String[list.size()]);
        Object[] expected = expectedResultStr.split("\n");
        Assert.assertEquals((String)"Different number of lines in expected and obtained result.", (long)expected.length, (long)result.length);
        Assert.assertArrayEquals((Object[])expected, (Object[])result);
    }

    public static void checkLinesAgainstRegexp(String resultPath, String regexp) {
        Pattern pattern = Pattern.compile(regexp);
        Matcher matcher = pattern.matcher("");
        ArrayList<String> list = new ArrayList<String>();
        try {
            TestBaseUtils.readAllResultLines(list, resultPath, new String[0], false);
        }
        catch (IOException e1) {
            Assert.fail((String)"Error reading the result");
        }
        for (String line : list) {
            matcher.reset(line);
            if (matcher.find()) continue;
            String msg = "Line is not well-formed: " + line;
            Assert.fail((String)msg);
        }
    }

    public static void compareKeyValuePairsWithDelta(String expectedLines, String resultPath, String delimiter, double maxDelta) throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        TestBaseUtils.readAllResultLines(list, resultPath, new String[0], false);
        Object[] result = list.toArray(new String[list.size()]);
        Object[] expected = expectedLines.isEmpty() ? new String[]{} : expectedLines.split("\n");
        Assert.assertEquals((String)"Wrong number of result lines.", (long)expected.length, (long)result.length);
        Arrays.sort(result);
        Arrays.sort(expected);
        for (int i = 0; i < expected.length; ++i) {
            double resultPayLoad;
            String[] expectedFields = ((String)expected[i]).split(delimiter);
            String[] resultFields = ((String)result[i]).split(delimiter);
            double expectedPayLoad = Double.parseDouble(expectedFields[1]);
            Assert.assertTrue((String)"Values differ by more than the permissible delta", (Math.abs(expectedPayLoad - (resultPayLoad = Double.parseDouble(resultFields[1]))) < maxDelta ? 1 : 0) != 0);
        }
    }

    public static <X> void compareResultCollections(List<X> expected, List<X> actual, Comparator<X> comparator) {
        Assert.assertEquals((long)expected.size(), (long)actual.size());
        Collections.sort(expected, comparator);
        Collections.sort(actual, comparator);
        for (int i = 0; i < expected.size(); ++i) {
            Assert.assertEquals(expected.get(i), actual.get(i));
        }
    }

    private static File[] getAllInvolvedFiles(String resultPath, String[] excludePrefixes) {
        File result = TestBaseUtils.asFile(resultPath);
        Assert.assertTrue((String)"Result file was not written", (boolean)result.exists());
        if (result.isDirectory()) {
            try {
                return (File[])Files.walk(result.toPath(), new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> {
                    for (String prefix : excludePrefixes) {
                        if (!path.getFileName().startsWith(prefix)) continue;
                        return false;
                    }
                    return true;
                }).map(Path::toFile).filter(file -> !file.isHidden()).toArray(File[]::new);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to retrieve result files");
            }
        }
        return new File[]{result};
    }

    public static File asFile(String path) {
        try {
            URI uri = new URI(path);
            if (uri.getScheme().equals("file")) {
                return new File(uri.getPath());
            }
            throw new IllegalArgumentException("This path does not denote a local file.");
        }
        catch (NullPointerException | URISyntaxException e) {
            throw new IllegalArgumentException("This path does not describe a valid local file URI.", e);
        }
    }

    public static <T> void compareResultAsTuples(List<T> result, String expected) {
        TestBaseUtils.compareResult(result, expected, true, true);
    }

    public static <T> void compareResultAsText(List<T> result, String expected) {
        TestBaseUtils.compareResult(result, expected, false, true);
    }

    public static <T> void compareOrderedResultAsText(List<T> result, String expected) {
        TestBaseUtils.compareResult(result, expected, false, false);
    }

    private static <T> void compareResult(List<T> result, String expected, boolean asTuples, boolean sort) {
        Object[] expectedStrings = expected.split("\n");
        Object[] resultStrings = new String[result.size()];
        for (int i = 0; i < resultStrings.length; ++i) {
            T val = result.get(i);
            if (asTuples) {
                if (val instanceof Tuple) {
                    Tuple t = (Tuple)val;
                    Object first = t.getField(0);
                    StringBuilder bld = new StringBuilder(first == null ? "null" : first.toString());
                    for (int pos = 1; pos < t.getArity(); ++pos) {
                        Object next = t.getField(pos);
                        bld.append(',').append(next == null ? "null" : next.toString());
                    }
                    resultStrings[i] = bld.toString();
                    continue;
                }
                throw new IllegalArgumentException(String.valueOf(val) + " is no tuple");
            }
            resultStrings[i] = val == null ? "null" : val.toString();
        }
        if (sort) {
            Arrays.sort(expectedStrings);
            Arrays.sort(resultStrings);
        }
        String msg = String.format("Different elements in arrays: expected %d elements and received %d\n expected: %s\n received: %s", expectedStrings.length, resultStrings.length, Arrays.toString(expectedStrings), Arrays.toString(resultStrings));
        Assert.assertEquals((String)msg, (long)expectedStrings.length, (long)resultStrings.length);
        for (int i = 0; i < expectedStrings.length; ++i) {
            Assert.assertEquals((String)msg, (Object)expectedStrings[i], (Object)resultStrings[i]);
        }
    }

    public static <T> void containsResultAsText(List<T> result, String expected) {
        String[] expectedStrings = expected.split("\n");
        ArrayList<String> resultStrings = new ArrayList<String>();
        for (T val : result) {
            String str = val == null ? "null" : val.toString();
            resultStrings.add(str);
        }
        List<String> expectedStringList = Arrays.asList(expectedStrings);
        for (String element : resultStrings) {
            Assert.assertTrue((boolean)expectedStringList.contains(element));
        }
    }

    public static class TupleComparator<T extends Tuple>
    implements Comparator<T> {
        @Override
        public int compare(T o1, T o2) {
            if (o1 == null || o2 == null) {
                throw new IllegalArgumentException("Cannot compare null tuples");
            }
            if (o1.getArity() != o2.getArity()) {
                return o1.getArity() - o2.getArity();
            }
            for (int i = 0; i < o1.getArity(); ++i) {
                int cmp;
                Object val1 = o1.getField(i);
                Object val2 = o2.getField(i);
                if (val1 != null && val2 != null) {
                    cmp = TupleComparator.compareValues(val1, val2);
                } else {
                    int n = val1 == null ? (val2 == null ? 0 : -1) : (cmp = 1);
                }
                if (cmp == 0) continue;
                return cmp;
            }
            return 0;
        }

        private static <X extends Comparable<X>> int compareValues(Object o1, Object o2) {
            if (o1 instanceof Comparable && o2 instanceof Comparable) {
                Comparable c1 = (Comparable)o1;
                Comparable c2 = (Comparable)o2;
                return c1.compareTo(c2);
            }
            throw new IllegalArgumentException("Cannot compare tuples with non comparable elements");
        }
    }
}

