/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.resources;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.flink.test.parameters.ParameterProperty;

public class ResourceTestUtils {
    private static final ParameterProperty<Path> MODULE_DIRECTORY = new ParameterProperty<Path>("moduleDir", x$0 -> Paths.get(x$0, new String[0]));

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Path getResource(String resourceNameRegex) {
        Path moduleDirectory = MODULE_DIRECTORY.get(Paths.get("", new String[0]).toAbsolutePath());
        try (Stream<Path> dependencyResources = Files.walk(moduleDirectory, new FileVisitOption[0]);){
            List matchingResources = dependencyResources.filter(jar -> Pattern.compile(resourceNameRegex).matcher(jar.toAbsolutePath().toString()).find()).collect(Collectors.toList());
            switch (matchingResources.size()) {
                case 0: {
                    throw new RuntimeException(new FileNotFoundException(String.format("No resource file could be found that matches the pattern %s. This could mean that the test module must be rebuilt via maven.", resourceNameRegex)));
                }
                case 1: {
                    Path path = (Path)matchingResources.get(0);
                    return path;
                }
            }
            throw new RuntimeException(new IOException(String.format("Multiple resource files were found matching the pattern %s. Matches=%s", resourceNameRegex, matchingResources)));
        }
        catch (IOException ioe) {
            throw new RuntimeException("Could not search for resource resource files.", ioe);
        }
    }
}

