/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.parameters;

import java.util.Optional;
import java.util.function.Function;

public class ParameterProperty<V> {
    private final String propertyName;
    private final Function<String, V> converter;

    public ParameterProperty(String propertyName, Function<String, V> converter) {
        this.propertyName = propertyName;
        this.converter = converter;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public Optional<V> get() {
        String value = System.getProperty(this.propertyName);
        return value == null ? Optional.empty() : Optional.of(this.converter.apply(value));
    }

    public V get(V defaultValue) {
        String value = System.getProperty(this.propertyName);
        return value == null ? defaultValue : this.converter.apply(value);
    }
}

