/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.metrics.testutils;

import org.apache.flink.metrics.Counter;
import org.apache.flink.metrics.Gauge;
import org.apache.flink.metrics.Metric;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;

public class MetricAssertions {
    public static CounterAssert assertThatCounter(Metric actual) {
        Assertions.assertThat((Object)actual).isInstanceOf(Counter.class);
        return new CounterAssert((Counter)actual);
    }

    public static <T> GaugeAssert<T> assertThatGauge(Metric actual) {
        Assertions.assertThat((Object)actual).isInstanceOf(Gauge.class);
        return new GaugeAssert((Gauge)actual);
    }

    public static class CounterAssert
    extends AbstractAssert<CounterAssert, Counter> {
        CounterAssert(Counter actual) {
            super((Object)actual, CounterAssert.class);
        }

        public CounterAssert isEqualTo(Object expected) {
            Assertions.assertThat((long)((Counter)this.actual).getCount()).isEqualTo(expected);
            return this;
        }
    }

    public static class GaugeAssert<T>
    extends AbstractAssert<GaugeAssert<T>, Gauge<T>> {
        GaugeAssert(Gauge<T> actual) {
            super(actual, GaugeAssert.class);
        }

        public GaugeAssert<T> isEqualTo(Object expected) {
            Assertions.assertThat((Object)((Gauge)this.actual).getValue()).isEqualTo(expected);
            return this;
        }

        public GaugeAssert<T> isCloseTo(long value, long epsilon) {
            Assertions.assertThat((Long)((Long)((Gauge)this.actual).getValue())).isGreaterThan(value - epsilon).isLessThan(value + epsilon);
            return this;
        }
    }
}

