/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.upserttest.sink;

import java.io.File;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.api.connector.sink2.Sink;
import org.apache.flink.api.connector.sink2.SinkWriter;
import org.apache.flink.api.connector.sink2.WriterInitContext;
import org.apache.flink.connector.upserttest.sink.UpsertTestSinkBuilder;
import org.apache.flink.connector.upserttest.sink.UpsertTestSinkWriter;
import org.apache.flink.util.FlinkRuntimeException;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public class UpsertTestSink<IN>
implements Sink<IN> {
    private final File outputFile;
    private final SerializationSchema<IN> keySerializationSchema;
    private final SerializationSchema<IN> valueSerializationSchema;

    UpsertTestSink(File outputFile, SerializationSchema<IN> keySerializationSchema, SerializationSchema<IN> valueSerializationSchema) {
        this.outputFile = (File)Preconditions.checkNotNull((Object)outputFile);
        this.keySerializationSchema = (SerializationSchema)Preconditions.checkNotNull(keySerializationSchema);
        this.valueSerializationSchema = (SerializationSchema)Preconditions.checkNotNull(valueSerializationSchema);
    }

    public static <IN> UpsertTestSinkBuilder<IN> builder() {
        return new UpsertTestSinkBuilder();
    }

    @Internal
    public SinkWriter<IN> createWriter(WriterInitContext context) {
        try {
            this.keySerializationSchema.open(context.asSerializationSchemaInitializationContext());
            this.valueSerializationSchema.open(context.asSerializationSchemaInitializationContext());
        }
        catch (Exception e) {
            throw new FlinkRuntimeException("Failed to initialize schema.", (Throwable)e);
        }
        return new UpsertTestSinkWriter<IN>(this.outputFile, this.keySerializationSchema, this.valueSerializationSchema);
    }
}

