/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.streaming.runtime.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.flink.api.common.functions.OpenContext;
import org.apache.flink.streaming.api.functions.sink.RichSinkFunction;
import org.apache.flink.test.streaming.runtime.util.TestListWrapper;

public class TestListResultSink<T>
extends RichSinkFunction<T> {
    private static final long serialVersionUID = 1L;
    private int resultListId = TestListWrapper.getInstance().createList();

    public void open(OpenContext openContext) throws Exception {
        super.open(openContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(T value) throws Exception {
        List<T> list = this.resultList();
        synchronized (list) {
            this.resultList().add(value);
        }
    }

    public void close() throws Exception {
        super.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<T> resultList() {
        TestListWrapper testListWrapper = TestListWrapper.getInstance();
        synchronized (testListWrapper) {
            return TestListWrapper.getInstance().getList(this.resultListId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<T> getResult() {
        List<T> list = this.resultList();
        synchronized (list) {
            ArrayList<T> copiedList = new ArrayList<T>(this.resultList());
            return copiedList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<T> getSortedResult() {
        List<T> list = this.resultList();
        synchronized (list) {
            ArrayList<T> sortedList = new ArrayList<T>(this.resultList());
            Collections.sort(sortedList);
            return sortedList;
        }
    }
}

