/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.upserttest.sink;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.connector.upserttest.sink.ImmutableByteArrayWrapper;
import org.apache.flink.util.CollectionUtil;
import org.apache.flink.util.Preconditions;

@Internal
public class UpsertTestFileUtil {
    static final byte MAGIC_BYTE = 13;

    private UpsertTestFileUtil() {
    }

    public static void writeRecords(BufferedOutputStream bos, Map<ImmutableByteArrayWrapper, ImmutableByteArrayWrapper> records) throws IOException {
        Preconditions.checkNotNull((Object)bos);
        for (Map.Entry<ImmutableByteArrayWrapper, ImmutableByteArrayWrapper> record : records.entrySet()) {
            byte[] key = record.getKey().array();
            byte[] value = record.getValue().array();
            bos.write(13);
            bos.write(key.length);
            bos.write(key);
            bos.write(value.length);
            bos.write(value);
        }
        bos.flush();
    }

    public static int getNumberOfRecords(BufferedInputStream bis) throws IOException {
        Map<ImmutableByteArrayWrapper, ImmutableByteArrayWrapper> records = UpsertTestFileUtil.readRecords(bis);
        return records.size();
    }

    public static int getNumberOfRecords(File file) throws IOException {
        Preconditions.checkNotNull((Object)file);
        FileInputStream fs = new FileInputStream(file);
        BufferedInputStream bis = new BufferedInputStream(fs);
        return UpsertTestFileUtil.getNumberOfRecords(bis);
    }

    public static <K, V> Map<K, V> readRecords(BufferedInputStream bis, DeserializationSchema<K> keyDeserializationSchema, DeserializationSchema<V> valueDeserializationSchema) throws IOException {
        Preconditions.checkNotNull((Object)bis);
        Map<ImmutableByteArrayWrapper, ImmutableByteArrayWrapper> bytesMap = UpsertTestFileUtil.readRecords(bis);
        HashMap typedMap = CollectionUtil.newHashMapWithExpectedSize((int)bytesMap.size());
        for (Map.Entry<ImmutableByteArrayWrapper, ImmutableByteArrayWrapper> entry : bytesMap.entrySet()) {
            Object key = keyDeserializationSchema.deserialize(entry.getKey().array());
            Object value = valueDeserializationSchema.deserialize(entry.getValue().array());
            typedMap.put(key, value);
        }
        return typedMap;
    }

    public static <K, V> Map<K, V> readRecords(File file, DeserializationSchema<K> keyDeserializationSchema, DeserializationSchema<V> valueDeserializationSchema) throws IOException {
        Preconditions.checkNotNull((Object)file);
        FileInputStream fs = new FileInputStream(file);
        BufferedInputStream bis = new BufferedInputStream(fs);
        return UpsertTestFileUtil.readRecords(bis, keyDeserializationSchema, valueDeserializationSchema);
    }

    private static Map<ImmutableByteArrayWrapper, ImmutableByteArrayWrapper> readRecords(BufferedInputStream bis) throws IOException {
        int magicByte;
        Preconditions.checkNotNull((Object)bis);
        HashMap<ImmutableByteArrayWrapper, ImmutableByteArrayWrapper> records = new HashMap<ImmutableByteArrayWrapper, ImmutableByteArrayWrapper>();
        while ((magicByte = bis.read()) != -1) {
            if (magicByte != 13) {
                throw new IOException("Data was serialized incorrectly or is corrupted.");
            }
            int keyLength = bis.read();
            byte[] key = new byte[keyLength];
            bis.read(key);
            int valueLength = bis.read();
            byte[] value = new byte[valueLength];
            bis.read(value);
            records.put(new ImmutableByteArrayWrapper(key), new ImmutableByteArrayWrapper(value));
        }
        return records;
    }
}

