/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.testutils.junit;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.flink.testutils.junit.SharedReference;
import org.junit.rules.ExternalResource;

@NotThreadSafe
public class SharedObjects
extends ExternalResource {
    private static final Map<Integer, SharedObjects> INSTANCES = new ConcurrentHashMap<Integer, SharedObjects>();
    private static final AtomicInteger LAST_ID = new AtomicInteger();
    private final int id;
    private final transient Map<SharedReference<?>, Object> objects = new ConcurrentHashMap();

    private SharedObjects(int id) {
        this.id = id;
    }

    public static SharedObjects create() {
        return new SharedObjects(LAST_ID.getAndIncrement());
    }

    private static SharedObjects get(int sharedObjectsId) {
        SharedObjects sharedObjects = INSTANCES.get(sharedObjectsId);
        if (sharedObjects == null) {
            throw new IllegalStateException("Object was accessed after the test was completed");
        }
        return sharedObjects;
    }

    public <T> SharedReference<T> add(T object) {
        DefaultTag tag = new DefaultTag(this.id, this.objects.size());
        this.objects.put(tag, object);
        return tag;
    }

    protected void before() throws Throwable {
        INSTANCES.put(this.id, this);
    }

    protected void after() {
        this.objects.clear();
        INSTANCES.remove(this.id);
    }

    <T> T get(SharedReference<T> tag) {
        Object object = this.objects.get(tag);
        if (object == null) {
            throw new IllegalStateException("Object was accessed after the test was completed");
        }
        return (T)object;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        SharedObjects that = (SharedObjects)((Object)o);
        return this.id == that.id;
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    private static class DefaultTag<T>
    implements SharedReference<T> {
        private final int sharedObjectsId;
        private final int objectId;

        public DefaultTag(int sharedObjectsId, int objectId) {
            this.sharedObjectsId = sharedObjectsId;
            this.objectId = objectId;
        }

        @Override
        public T get() {
            return SharedObjects.get(this.sharedObjectsId).get(this);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DefaultTag that = (DefaultTag)o;
            return this.sharedObjectsId == that.sharedObjectsId && this.objectId == that.objectId;
        }

        public int hashCode() {
            return Objects.hash(this.sharedObjectsId, this.objectId);
        }
    }
}

