/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.core.testutils;

public abstract class CheckedThread
extends Thread {
    private volatile Throwable error;

    public CheckedThread() {
    }

    public CheckedThread(String name) {
        super(name);
    }

    public abstract void go() throws Exception;

    @Override
    public final void run() {
        try {
            this.go();
        }
        catch (Throwable t) {
            this.error = t;
        }
    }

    public void sync() throws Exception {
        this.sync(0L);
    }

    public void sync(long timeout) throws Exception {
        this.trySync(timeout);
        this.checkFinished();
    }

    public void trySync(long timeout) throws Exception {
        this.join(timeout);
        this.checkError();
    }

    private void checkError() throws Exception {
        if (this.error != null) {
            if (this.error instanceof Error) {
                throw (Error)this.error;
            }
            if (this.error instanceof Exception) {
                throw (Exception)this.error;
            }
            throw new Exception(this.error.getMessage(), this.error);
        }
    }

    private void checkFinished() throws Exception {
        if (this.getState() != Thread.State.TERMINATED) {
            throw new Exception(String.format("%s[name = %s] has not finished!", this.getClass().getSimpleName(), this.getName()));
        }
    }
}

