/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.core.testutils;

import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apache.flink.core.testutils.CustomExtension;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.testcontainers.containers.GenericContainer;

public class TestContainerExtension<T extends GenericContainer<T>>
implements CustomExtension {
    @Nullable
    private T testContainer;
    private final Supplier<T> testContainerCreator;

    public TestContainerExtension(Supplier<T> testContainerCreator) {
        this.testContainerCreator = testContainerCreator;
    }

    public T getTestContainer() {
        assert (this.testContainer != null);
        return this.testContainer;
    }

    private void terminateTestContainer() {
        if (this.testContainer != null) {
            this.testContainer.stop();
            this.testContainer = null;
        }
    }

    private void instantiateTestContainer() {
        assert (this.testContainer == null);
        this.testContainer = (GenericContainer)this.testContainerCreator.get();
        this.testContainer.start();
    }

    @Override
    public void after(ExtensionContext context) throws Exception {
        this.terminateTestContainer();
    }

    @Override
    public void before(ExtensionContext context) throws Exception {
        this.terminateTestContainer();
        this.instantiateTestContainer();
    }
}

