/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.core.testutils;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;

public class FilteredClassLoader
extends ClassLoader {
    private final HashSet<String> filteredClassNames;

    public FilteredClassLoader(ClassLoader delegate, String ... filteredClassNames) {
        super(Objects.requireNonNull(delegate));
        this.filteredClassNames = new HashSet<String>(Arrays.asList(filteredClassNames));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        FilteredClassLoader filteredClassLoader = this;
        synchronized (filteredClassLoader) {
            if (this.filteredClassNames.contains(name)) {
                throw new ClassNotFoundException(name);
            }
            return super.loadClass(name, resolve);
        }
    }
}

