/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.sort;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.runtime.io.disk.RandomAccessInputView;
import org.apache.flink.runtime.memory.AbstractPagedInputView;
import org.apache.flink.runtime.memory.AbstractPagedOutputView;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.binary.BinaryRowData;
import org.apache.flink.table.runtime.generated.NormalizedKeyComputer;
import org.apache.flink.table.runtime.generated.RecordComparator;
import org.apache.flink.table.runtime.operators.sort.BinaryIndexedSortable;
import org.apache.flink.table.runtime.typeutils.BinaryRowDataSerializer;
import org.apache.flink.table.runtime.util.MemorySegmentPool;
import org.apache.flink.util.MutableObjectIterator;
import org.apache.flink.util.Preconditions;

public class BinaryKVInMemorySortBuffer
extends BinaryIndexedSortable {
    private final BinaryRowDataSerializer valueSerializer;

    public static BinaryKVInMemorySortBuffer createBuffer(NormalizedKeyComputer normalizedKeyComputer, BinaryRowDataSerializer keySerializer, BinaryRowDataSerializer valueSerializer, RecordComparator comparator, ArrayList<MemorySegment> recordBufferSegments, long numElements, MemorySegmentPool pool) throws IOException {
        BinaryKVInMemorySortBuffer sorter = new BinaryKVInMemorySortBuffer(normalizedKeyComputer, keySerializer, valueSerializer, comparator, recordBufferSegments, pool);
        sorter.load(numElements, sorter.recordBuffer);
        return sorter;
    }

    private BinaryKVInMemorySortBuffer(NormalizedKeyComputer normalizedKeyComputer, BinaryRowDataSerializer keySerializer, BinaryRowDataSerializer valueSerializer, RecordComparator comparator, ArrayList<MemorySegment> recordBufferSegments, MemorySegmentPool memorySegmentPool) {
        super(normalizedKeyComputer, keySerializer, comparator, recordBufferSegments, memorySegmentPool);
        this.valueSerializer = valueSerializer;
    }

    @Override
    public void writeToOutput(AbstractPagedOutputView output) throws IOException {
        int numRecords = this.numRecords;
        int currentMemSeg = 0;
        int currentRecord = 0;
        while (currentRecord < numRecords) {
            MemorySegment currentIndexSegment = (MemorySegment)this.sortIndex.get(currentMemSeg++);
            for (int offset = 0; currentRecord < numRecords && offset <= this.lastIndexEntryOffset; ++currentRecord, offset += this.indexEntrySize) {
                long pointer = currentIndexSegment.getLong(offset);
                this.recordBuffer.setReadPosition(pointer);
                this.serializer.copyFromPagesToView((AbstractPagedInputView)this.recordBuffer, (DataOutputView)output);
                this.valueSerializer.copyFromPagesToView((AbstractPagedInputView)this.recordBuffer, (DataOutputView)output);
            }
        }
    }

    private void load(long numElements, RandomAccessInputView recordInputView) throws IOException {
        int index = 0;
        while ((long)index < numElements) {
            this.serializer.checkSkipReadForFixLengthPart((AbstractPagedInputView)recordInputView);
            long pointer = recordInputView.getReadPosition();
            BinaryRowData row = this.serializer1.mapFromPages(this.row1, (AbstractPagedInputView)recordInputView);
            this.valueSerializer.checkSkipReadForFixLengthPart((AbstractPagedInputView)recordInputView);
            recordInputView.skipBytes(recordInputView.readInt());
            boolean success = this.checkNextIndexOffset();
            Preconditions.checkArgument((boolean)success);
            this.writeIndexAndNormalizedKey((RowData)row, pointer);
            ++index;
        }
    }

    public final MutableObjectIterator<Tuple2<BinaryRowData, BinaryRowData>> getIterator() {
        return new MutableObjectIterator<Tuple2<BinaryRowData, BinaryRowData>>(){
            private final int size;
            private int current;
            private int currentSegment;
            private int currentOffset;
            private MemorySegment currentIndexSegment;
            {
                this.size = BinaryKVInMemorySortBuffer.this.size();
                this.current = 0;
                this.currentSegment = 0;
                this.currentOffset = 0;
                this.currentIndexSegment = (MemorySegment)BinaryKVInMemorySortBuffer.this.sortIndex.get(0);
            }

            public Tuple2<BinaryRowData, BinaryRowData> next(Tuple2<BinaryRowData, BinaryRowData> kv) {
                if (this.current < this.size) {
                    ++this.current;
                    if (this.currentOffset > BinaryKVInMemorySortBuffer.this.lastIndexEntryOffset) {
                        this.currentOffset = 0;
                        this.currentIndexSegment = (MemorySegment)BinaryKVInMemorySortBuffer.this.sortIndex.get(++this.currentSegment);
                    }
                    long pointer = this.currentIndexSegment.getLong(this.currentOffset);
                    this.currentOffset += BinaryKVInMemorySortBuffer.this.indexEntrySize;
                    try {
                        return BinaryKVInMemorySortBuffer.this.getRecordFromBuffer((BinaryRowData)kv.f0, (BinaryRowData)kv.f1, pointer);
                    }
                    catch (IOException ioe) {
                        throw new RuntimeException(ioe);
                    }
                }
                return null;
            }

            public Tuple2<BinaryRowData, BinaryRowData> next() {
                throw new RuntimeException("Not support!");
            }
        };
    }

    private Tuple2<BinaryRowData, BinaryRowData> getRecordFromBuffer(BinaryRowData reuseKey, BinaryRowData reuseValue, long pointer) throws IOException {
        this.recordBuffer.setReadPosition(pointer);
        reuseKey = this.serializer.mapFromPages(reuseKey, (AbstractPagedInputView)this.recordBuffer);
        reuseValue = this.serializer.mapFromPages(reuseValue, (AbstractPagedInputView)this.recordBuffer);
        return Tuple2.of((Object)reuseKey, (Object)reuseValue);
    }
}

