/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.process;

import org.apache.flink.annotation.Internal;
import org.apache.flink.streaming.api.operators.Output;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.table.api.TableRuntimeException;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.data.utils.JoinedRowData;
import org.apache.flink.table.runtime.operators.process.RepeatedRowData;
import org.apache.flink.table.runtime.util.StreamRecordCollector;
import org.apache.flink.types.RowKind;

@Internal
public abstract class PassThroughCollectorBase
extends StreamRecordCollector<RowData> {
    private final RepeatedRowData repeatedPrefix;
    private final JoinedRowData withFunctionOutput;
    private final JoinedRowData withRowtime;
    private final ChangelogMode changelogMode;
    protected RowData prefix;
    private RowData rowtime;

    public PassThroughCollectorBase(Output<StreamRecord<RowData>> output, ChangelogMode changelogMode, int prefixRepetition) {
        super(output);
        this.changelogMode = changelogMode;
        this.repeatedPrefix = new RepeatedRowData(prefixRepetition);
        this.withFunctionOutput = new JoinedRowData();
        this.withRowtime = new JoinedRowData();
        this.prefix = GenericRowData.of((Object[])new Object[0]);
        this.rowtime = GenericRowData.of((Object[])new Object[0]);
    }

    public abstract void setPrefix(int var1, RowData var2);

    public void setRowtime(Long time) {
        this.rowtime = GenericRowData.of((Object[])new Object[]{TimestampData.fromEpochMillis((long)time)});
    }

    @Override
    public void collect(RowData functionOutput) {
        this.repeatedPrefix.replace(this.prefix);
        this.withFunctionOutput.replace((RowData)this.repeatedPrefix, functionOutput);
        this.withRowtime.replace((RowData)this.withFunctionOutput, this.rowtime);
        RowKind kind = functionOutput.getRowKind();
        if (!this.changelogMode.contains(kind)) {
            throw new TableRuntimeException(String.format("Invalid row kind received: %s. Expected produced changelog mode: %s", kind, this.changelogMode));
        }
        this.withRowtime.setRowKind(kind);
        super.collect(this.withRowtime);
    }
}

