/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.join.lookup.keyordered;

import java.util.LinkedList;
import java.util.Optional;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.table.runtime.operators.join.lookup.keyordered.Epoch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EpochManager<OUT> {
    private static final Logger LOG = LoggerFactory.getLogger(EpochManager.class);
    private final LinkedList<Epoch<OUT>> outputQueue;
    private Epoch<OUT> activeEpoch;
    private Watermark currentWatermark = new Watermark(Long.MIN_VALUE);

    public EpochManager() {
        this.outputQueue = new LinkedList();
        this.activeEpoch = new Epoch(this.currentWatermark);
        this.outputQueue.offer(this.activeEpoch);
    }

    public Epoch<OUT> onRecord() {
        this.activeEpoch.incrementCount();
        return this.activeEpoch;
    }

    public Optional<Epoch<OUT>> getProperEpoch(Watermark watermark) {
        for (Epoch epoch : this.outputQueue) {
            if (!epoch.getWatermark().equals((Object)watermark)) continue;
            return Optional.of(epoch);
        }
        return Optional.empty();
    }

    public void onNonRecord(Watermark watermark, Runnable action) {
        this.activeEpoch.close(action);
        this.activeEpoch = new Epoch(watermark);
        this.outputQueue.offer(this.activeEpoch);
        this.currentWatermark = watermark;
        this.tryFinishInQueue();
    }

    public void completeOneRecord(Epoch<OUT> epoch) {
        epoch.decrementCount();
        this.tryFinishInQueue();
    }

    public void close() {
        for (Epoch epoch : this.outputQueue) {
            epoch.free();
        }
        this.outputQueue.clear();
    }

    @VisibleForTesting
    public Epoch<OUT> getActiveEpoch() {
        return this.activeEpoch;
    }

    @VisibleForTesting
    public LinkedList<Epoch<OUT>> getOutputQueue() {
        return this.outputQueue;
    }

    private void tryFinishInQueue() {
        while (!this.outputQueue.isEmpty() && this.outputQueue.peek().tryFinish()) {
            LOG.debug("Finish epoch: {}, outputQueue size: {}", this.outputQueue.peek(), (Object)this.outputQueue.size());
            this.outputQueue.pop();
        }
    }
}

