/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.functions.table;

import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.data.ArrayData;
import org.apache.flink.table.data.MapData;
import org.apache.flink.table.functions.BuiltInFunctionDefinitions;
import org.apache.flink.table.functions.SpecializedFunction;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.runtime.functions.BuiltInSpecializedFunction;
import org.apache.flink.table.runtime.functions.table.BuiltInTableFunction;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.ArrayType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.MapType;
import org.apache.flink.table.types.logical.MultisetType;
import org.apache.flink.table.types.logical.RowType;

@Internal
public abstract class UnnestRowsFunctionBase
extends BuiltInSpecializedFunction {
    public UnnestRowsFunctionBase(boolean withOrdinality) {
        super(withOrdinality ? BuiltInFunctionDefinitions.INTERNAL_UNNEST_ROWS_WITH_ORDINALITY : BuiltInFunctionDefinitions.INTERNAL_UNNEST_ROWS);
    }

    public UserDefinedFunction specialize(SpecializedFunction.SpecializedContext context) {
        LogicalType argType = ((DataType)context.getCallContext().getArgumentDataTypes().get(0)).getLogicalType();
        switch (argType.getTypeRoot()) {
            case ARRAY: {
                ArrayType arrayType = (ArrayType)argType;
                return this.createCollectionUnnestFunction(context, arrayType.getElementType(), ArrayData.createElementGetter((LogicalType)arrayType.getElementType()));
            }
            case MULTISET: {
                MultisetType multisetType = (MultisetType)argType;
                return this.createCollectionUnnestFunction(context, multisetType.getElementType(), ArrayData.createElementGetter((LogicalType)multisetType.getElementType()));
            }
            case MAP: {
                MapType mapType = (MapType)argType;
                return this.createMapUnnestFunction(context, RowType.of((boolean)false, (LogicalType[])new LogicalType[]{mapType.getKeyType(), mapType.getValueType()}), ArrayData.createElementGetter((LogicalType)mapType.getKeyType()), ArrayData.createElementGetter((LogicalType)mapType.getValueType()));
            }
        }
        throw new UnsupportedOperationException("Unsupported type for UNNEST: " + argType);
    }

    protected abstract UserDefinedFunction createCollectionUnnestFunction(SpecializedFunction.SpecializedContext var1, LogicalType var2, ArrayData.ElementGetter var3);

    protected abstract UserDefinedFunction createMapUnnestFunction(SpecializedFunction.SpecializedContext var1, RowType var2, ArrayData.ElementGetter var3, ArrayData.ElementGetter var4);

    public static LogicalType getUnnestedType(LogicalType logicalType, boolean withOrdinality) {
        LogicalType elementType;
        switch (logicalType.getTypeRoot()) {
            case ARRAY: {
                elementType = ((ArrayType)logicalType).getElementType();
                break;
            }
            case MULTISET: {
                elementType = ((MultisetType)logicalType).getElementType();
                break;
            }
            case MAP: {
                MapType mapType = (MapType)logicalType;
                elementType = RowType.of((boolean)false, (LogicalType[])new LogicalType[]{mapType.getKeyType(), mapType.getValueType()});
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported UNNEST type: " + logicalType);
            }
        }
        if (withOrdinality) {
            return UnnestRowsFunctionBase.wrapWithOrdinality(elementType);
        }
        return elementType;
    }

    public static LogicalType wrapWithOrdinality(LogicalType baseType) {
        if (baseType instanceof RowType) {
            RowType rowType = (RowType)baseType;
            return new RowType(false, Stream.concat(rowType.getFields().stream(), Stream.of(new RowType.RowField("ORDINALITY", ((DataType)DataTypes.INT().notNull()).getLogicalType()))).collect(Collectors.toList()));
        }
        return RowType.of((boolean)false, (LogicalType[])new LogicalType[]{baseType, ((DataType)DataTypes.INT().notNull()).getLogicalType()}, (String[])new String[]{"EXPR$0", "ORDINALITY"});
    }

    protected static abstract class UnnestTableFunctionBase
    extends BuiltInTableFunction<Object> {
        private final transient DataType outputDataType;

        UnnestTableFunctionBase(SpecializedFunction.SpecializedContext context, LogicalType elementType, boolean withOrdinality) {
            super(withOrdinality ? BuiltInFunctionDefinitions.INTERNAL_UNNEST_ROWS_WITH_ORDINALITY : BuiltInFunctionDefinitions.INTERNAL_UNNEST_ROWS, context);
            this.outputDataType = DataTypes.of((LogicalType)elementType).toInternal();
        }

        @Override
        public DataType getOutputDataType() {
            return this.outputDataType;
        }

        protected void evalArrayData(ArrayData arrayData, ArrayData.ElementGetter elementGetter, UnnestCollector collector) {
            if (arrayData == null) {
                return;
            }
            int size = arrayData.size();
            for (int pos = 0; pos < size; ++pos) {
                collector.collect(elementGetter.getElementOrNull(arrayData, pos), pos + 1);
            }
        }

        protected void evalMapData(MapData mapData, ArrayData.ElementGetter keyGetter, ArrayData.ElementGetter valueGetter, MapUnnestCollector collector) {
            if (mapData == null) {
                return;
            }
            int size = mapData.size();
            ArrayData keyArray = mapData.keyArray();
            ArrayData valueArray = mapData.valueArray();
            for (int pos = 0; pos < size; ++pos) {
                collector.collect(keyGetter.getElementOrNull(keyArray, pos), valueGetter.getElementOrNull(valueArray, pos), pos + 1);
            }
        }

        protected void evalMultisetData(MapData mapData, ArrayData.ElementGetter elementGetter, UnnestCollector collector) {
            if (mapData == null) {
                return;
            }
            int size = mapData.size();
            ArrayData keys = mapData.keyArray();
            ArrayData values = mapData.valueArray();
            int ordinal = 1;
            for (int pos = 0; pos < size; ++pos) {
                int multiplier = values.getInt(pos);
                Object key = elementGetter.getElementOrNull(keys, pos);
                for (int i = 0; i < multiplier; ++i) {
                    collector.collect(key, ordinal++);
                }
            }
        }

        @FunctionalInterface
        protected static interface MapUnnestCollector {
            public void collect(Object var1, Object var2, int var3);
        }

        @FunctionalInterface
        protected static interface UnnestCollector {
            public void collect(Object var1, int var2);
        }
    }
}

