/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.functions.table;

import org.apache.flink.annotation.Internal;
import org.apache.flink.table.data.ArrayData;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.MapData;
import org.apache.flink.table.functions.SpecializedFunction;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.runtime.functions.table.UnnestRowsFunctionBase;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;

@Internal
public class UnnestRowsFunction
extends UnnestRowsFunctionBase {
    public UnnestRowsFunction() {
        super(false);
    }

    @Override
    protected UserDefinedFunction createCollectionUnnestFunction(SpecializedFunction.SpecializedContext context, LogicalType elementType, ArrayData.ElementGetter elementGetter) {
        return new CollectionUnnestFunction(context, elementType, elementGetter);
    }

    @Override
    protected UserDefinedFunction createMapUnnestFunction(SpecializedFunction.SpecializedContext context, RowType keyValTypes, ArrayData.ElementGetter keyGetter, ArrayData.ElementGetter valueGetter) {
        return new MapUnnestFunction(context, (LogicalType)keyValTypes, keyGetter, valueGetter);
    }

    public static final class MapUnnestFunction
    extends UnnestRowsFunctionBase.UnnestTableFunctionBase {
        private static final long serialVersionUID = 1L;
        private final ArrayData.ElementGetter keyGetter;
        private final ArrayData.ElementGetter valueGetter;

        public MapUnnestFunction(SpecializedFunction.SpecializedContext context, LogicalType keyValTypes, ArrayData.ElementGetter keyGetter, ArrayData.ElementGetter valueGetter) {
            super(context, keyValTypes, false);
            this.keyGetter = keyGetter;
            this.valueGetter = valueGetter;
        }

        public void eval(MapData mapData) {
            this.evalMapData(mapData, this.keyGetter, this.valueGetter, (key, value, position) -> this.collect(GenericRowData.of((Object[])new Object[]{key, value})));
        }
    }

    public static final class CollectionUnnestFunction
    extends UnnestRowsFunctionBase.UnnestTableFunctionBase {
        private static final long serialVersionUID = 1L;
        private final ArrayData.ElementGetter elementGetter;

        public CollectionUnnestFunction(SpecializedFunction.SpecializedContext context, LogicalType elementType, ArrayData.ElementGetter elementGetter) {
            super(context, elementType, false);
            this.elementGetter = elementGetter;
        }

        public void eval(ArrayData arrayData) {
            this.evalArrayData(arrayData, this.elementGetter, (element, position) -> this.collect(element));
        }

        public void eval(MapData mapData) {
            this.evalMultisetData(mapData, this.elementGetter, (element, position) -> this.collect(element));
        }
    }
}

