/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.functions.scalar;

import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.data.ArrayData;
import org.apache.flink.table.data.GenericArrayData;
import org.apache.flink.table.functions.BuiltInFunctionDefinitions;
import org.apache.flink.table.functions.SpecializedFunction;
import org.apache.flink.table.runtime.functions.scalar.BuiltInScalarFunction;
import org.apache.flink.table.types.CollectionDataType;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;

@Internal
public class ArrayReverseFunction
extends BuiltInScalarFunction {
    private final ArrayData.ElementGetter elementGetter;

    public ArrayReverseFunction(SpecializedFunction.SpecializedContext context) {
        super(BuiltInFunctionDefinitions.ARRAY_REVERSE, context);
        DataType dataType = ((CollectionDataType)context.getCallContext().getArgumentDataTypes().get(0)).getElementDataType();
        this.elementGetter = ArrayData.createElementGetter((LogicalType)dataType.getLogicalType());
    }

    @Nullable
    public ArrayData eval(ArrayData haystack) {
        if (haystack == null) {
            return null;
        }
        if (haystack.size() <= 1) {
            return haystack;
        }
        Object[] array = new Object[haystack.size()];
        for (int i = 0; i < haystack.size(); ++i) {
            Object element;
            array[haystack.size() - 1 - i] = element = this.elementGetter.getElementOrNull(haystack, i);
        }
        return new GenericArrayData(array);
    }
}

