/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.typeutils;

import java.util.Comparator;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.table.runtime.typeutils.AbstractMapSerializer;
import org.apache.flink.table.runtime.typeutils.SortedMapSerializerSnapshot;

public final class SortedMapSerializer<K, V>
extends AbstractMapSerializer<K, V, SortedMap<K, V>> {
    private static final long serialVersionUID = 1L;
    private final Comparator<K> comparator;

    public SortedMapSerializer(Comparator<K> comparator, TypeSerializer<K> keySerializer, TypeSerializer<V> valueSerializer) {
        super(keySerializer, valueSerializer);
        this.comparator = comparator;
    }

    public Comparator<K> getComparator() {
        return this.comparator;
    }

    public TypeSerializer<SortedMap<K, V>> duplicate() {
        TypeSerializer keySerializer = this.getKeySerializer().duplicate();
        TypeSerializer valueSerializer = this.getValueSerializer().duplicate();
        return new SortedMapSerializer<K, V>(this.comparator, keySerializer, valueSerializer);
    }

    public SortedMap<K, V> createInstance() {
        return new TreeMap(this.comparator);
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        SortedMapSerializer that = (SortedMapSerializer)((Object)o);
        return this.comparator.equals(that.comparator);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = result * 31 + this.comparator.hashCode();
        return result;
    }

    public String toString() {
        return "SortedMapSerializer{comparator = " + this.comparator + ", keySerializer = " + this.keySerializer + ", valueSerializer = " + this.valueSerializer + "}";
    }

    public TypeSerializerSnapshot<SortedMap<K, V>> snapshotConfiguration() {
        return new SortedMapSerializerSnapshot(this);
    }
}

