/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.window.groupwindow.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import org.apache.flink.api.common.state.MapState;
import org.apache.flink.table.runtime.operators.window.MergeCallback;
import org.apache.flink.table.runtime.operators.window.Window;
import org.apache.flink.table.runtime.operators.window.groupwindow.assigners.MergingWindowAssigner;
import org.apache.flink.table.runtime.util.LRUMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MergingWindowSet<W extends Window> {
    private static final Logger LOG = LoggerFactory.getLogger(MergingWindowSet.class);
    private static final int MAPPING_CACHE_SIZE = 10000;
    private final MapState<W, W> mapping;
    private final LRUMap<Object, TreeSet<W>> cachedSortedWindows;
    private TreeSet<W> sortedWindows;
    private final MergingWindowAssigner<W> windowAssigner;

    public MergingWindowSet(MergingWindowAssigner<W> windowAssigner, MapState<W, W> mapping) {
        this.windowAssigner = windowAssigner;
        this.mapping = mapping;
        this.cachedSortedWindows = new LRUMap(10000);
    }

    public void initializeCache(Object key) throws Exception {
        this.sortedWindows = (TreeSet)this.cachedSortedWindows.get(key);
        if (this.sortedWindows == null) {
            this.sortedWindows = new TreeSet();
            Iterator keyValues = this.mapping.iterator();
            if (keyValues != null) {
                while (keyValues.hasNext()) {
                    Map.Entry keyValue = (Map.Entry)keyValues.next();
                    this.sortedWindows.add((Window)keyValue.getKey());
                }
            }
            this.cachedSortedWindows.put(key, this.sortedWindows);
        }
    }

    public W getStateWindow(W window) throws Exception {
        return (W)((Window)this.mapping.get(window));
    }

    public void retireWindow(W window) throws Exception {
        this.mapping.remove(window);
        boolean removed = this.sortedWindows.remove(window);
        if (!removed) {
            throw new IllegalStateException("Window " + window + " is not in in-flight window set.");
        }
    }

    public W addWindow(W newWindow, MergeFunction<W> mergeFunction) throws Exception {
        MergeResultCollector collector = new MergeResultCollector();
        this.windowAssigner.mergeWindows(newWindow, this.sortedWindows, collector);
        Object resultWindow = newWindow;
        boolean isNewWindowMerged = false;
        for (Map.Entry c : collector.mergeResults.entrySet()) {
            Window mergeResult = (Window)c.getKey();
            Collection mergedWindows = c.getValue();
            if (mergedWindows.remove(newWindow)) {
                isNewWindowMerged = true;
                resultWindow = mergeResult;
            }
            if (mergedWindows.isEmpty()) continue;
            Window mergedStateNamespace = (Window)this.mapping.get((Object)((Window)mergedWindows.iterator().next()));
            ArrayList<Window> mergedStateWindows = new ArrayList<Window>();
            for (Window mergedWindow : mergedWindows) {
                Window res = (Window)this.mapping.get((Object)mergedWindow);
                if (res == null) continue;
                this.mapping.remove((Object)mergedWindow);
                this.sortedWindows.remove(mergedWindow);
                if (res.equals(mergedStateNamespace)) continue;
                mergedStateWindows.add(res);
            }
            this.mapping.put((Object)mergeResult, (Object)mergedStateNamespace);
            this.sortedWindows.add(mergeResult);
            if (mergedWindows.contains(mergeResult) && mergedWindows.size() == 1) continue;
            mergeFunction.merge(mergeResult, mergedWindows, mergedStateNamespace, mergedStateWindows);
        }
        if (collector.mergeResults.isEmpty() || ((Window)resultWindow).equals(newWindow) && !isNewWindowMerged) {
            this.mapping.put(resultWindow, resultWindow);
            this.sortedWindows.add(resultWindow);
        }
        return resultWindow;
    }

    public String toString() {
        return "MergingWindowSet{windows=" + this.mapping + "}";
    }

    public static interface MergeFunction<W> {
        public void merge(W var1, Collection<W> var2, W var3, Collection<W> var4) throws Exception;
    }

    private class MergeResultCollector
    implements MergeCallback<W, Collection<W>> {
        final Map<W, Collection<W>> mergeResults = new HashMap();

        private MergeResultCollector() {
        }

        @Override
        public void merge(W mergeResult, Collection<W> toBeMerged) {
            LOG.debug("Merging {} into {}", toBeMerged, mergeResult);
            this.mergeResults.put(mergeResult, toBeMerged);
        }
    }
}

