/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.application;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import javax.annotation.Nullable;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.io.IOUtils;
import org.apache.flink.core.fs.FSDataInputStream;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.util.FileUtils;
import org.apache.flink.util.MutableURLClassLoader;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlDriver {
    private static final Logger LOG = LoggerFactory.getLogger(SqlDriver.class);
    public static final Option OPTION_SQL_FILE = Option.builder().longOpt("scriptUri").numberOfArgs(1).desc("SQL script file URI. It supports to fetch files from the DFS or HTTP.").build();
    public static final Option OPTION_SQL_SCRIPT = Option.builder().longOpt("script").numberOfArgs(1).desc("Script content.").build();
    private static final String RUNNER_CLASS_NAME = "org.apache.flink.table.gateway.service.application.ScriptRunner";
    private static boolean testMode = false;
    private static OutputStream testOutputStream;

    public static void main(String[] args) throws Exception {
        String sql = SqlDriver.parseOptions(args);
        if (testMode) {
            SqlDriver.getClassLoader().loadClass(RUNNER_CLASS_NAME).getMethod("run", String.class, OutputStream.class).invoke(null, sql, Preconditions.checkNotNull((Object)testOutputStream));
        } else {
            SqlDriver.getClassLoader().loadClass(RUNNER_CLASS_NAME).getMethod("run", String.class).invoke(null, sql);
        }
    }

    public static void enableTestMode(OutputStream outputStream) {
        testOutputStream = outputStream;
        testMode = true;
    }

    public static void disableTestMode() {
        testOutputStream = null;
        testMode = false;
    }

    private static ClassLoader getClassLoader() throws Exception {
        MutableURLClassLoader sqlGatewayClassloader = (MutableURLClassLoader)Thread.currentThread().getContextClassLoader();
        try {
            sqlGatewayClassloader.loadClass(RUNNER_CLASS_NAME);
            LOG.info("Load {} from the classpath.", (Object)RUNNER_CLASS_NAME);
        }
        catch (ClassNotFoundException e) {
            LOG.info("{} is not in the classpath. Finding...", (Object)RUNNER_CLASS_NAME);
            sqlGatewayClassloader.addURL(SqlDriver.findExecutor().toUri().toURL());
        }
        return sqlGatewayClassloader;
    }

    private static java.nio.file.Path findExecutor() {
        String flinkOptPath = System.getenv("FLINK_OPT_DIR");
        final ArrayList sqlJarPaths = new ArrayList();
        try {
            Files.walkFileTree(FileSystems.getDefault().getPath(flinkOptPath, new String[0]), (FileVisitor<? super java.nio.file.Path>)new SimpleFileVisitor<java.nio.file.Path>(){

                @Override
                public FileVisitResult visitFile(java.nio.file.Path file, BasicFileAttributes attrs) throws IOException {
                    FileVisitResult result = super.visitFile(file, attrs);
                    if (file.getFileName().toString().startsWith("flink-sql-gateway")) {
                        sqlJarPaths.add(file);
                    }
                    return result;
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeException("Exception encountered during finding the flink-sql-gateway jar. This should not happen.", e);
        }
        if (sqlJarPaths.size() != 1) {
            throw new RuntimeException("Found " + sqlJarPaths.size() + " flink-sql-gateway jar.");
        }
        return (java.nio.file.Path)sqlJarPaths.get(0);
    }

    static Options getSqlDriverOptions() {
        Options options = new Options();
        options.addOption(OPTION_SQL_FILE);
        options.addOption(OPTION_SQL_SCRIPT);
        return options;
    }

    public static String parseOptions(String[] args) {
        try {
            DefaultParser parser = new DefaultParser();
            CommandLine line = parser.parse(SqlDriver.getSqlDriverOptions(), args, true);
            String content = SqlDriver.getContent(line.getOptionValue(OPTION_SQL_FILE.getLongOpt()));
            if (content == null) {
                return (String)Preconditions.checkNotNull((Object)line.getOptionValue(OPTION_SQL_SCRIPT.getLongOpt()), (String)"Please use \"--script\" or \"--scriptUri\" to specify script either.");
            }
            Preconditions.checkArgument((line.getOptionValue(OPTION_SQL_SCRIPT.getLongOpt()) == null ? 1 : 0) != 0, (Object)"Don't set \"--script\" or \"--scriptUri\" together.");
            return content;
        }
        catch (URISyntaxException | ParseException e) {
            throw new IllegalArgumentException("Failed to parse args. It should never happens.", e);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Can not read files to execute.", e);
        }
    }

    @Nullable
    private static String getContent(@Nullable String filePath) throws IOException, URISyntaxException {
        if (filePath == null) {
            return null;
        }
        URI resolvedUri = SqlDriver.resolveURI(filePath);
        if (resolvedUri.getScheme().equals("http") || resolvedUri.getScheme().equals("https")) {
            return SqlDriver.readFromHttp(resolvedUri);
        }
        return SqlDriver.readFileUtf8(resolvedUri);
    }

    private static URI resolveURI(String path) throws URISyntaxException {
        URI uri = new URI(path);
        if (uri.getScheme() != null) {
            return uri;
        }
        return new File(path).getAbsoluteFile().toURI();
    }

    private static String readFromHttp(URI uri) throws IOException {
        URL url = uri.toURL();
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("GET");
        try (InputStream inputStream = conn.getInputStream();){
            String string;
            try (ByteArrayOutputStream targetFile = new ByteArrayOutputStream();){
                IOUtils.copy((InputStream)inputStream, (OutputStream)targetFile);
                string = targetFile.toString(StandardCharsets.UTF_8);
            }
            return string;
        }
    }

    private static String readFileUtf8(URI uri) throws IOException {
        Path path = new Path(uri);
        FileSystem fs = path.getFileSystem();
        try (FSDataInputStream inputStream = fs.open(path);){
            String string = new String(FileUtils.read((InputStream)inputStream, (int)((int)fs.getFileStatus(path).getLen())), StandardCharsets.UTF_8);
            return string;
        }
    }
}

