/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.functions.scalar;

import java.lang.invoke.MethodHandle;
import java.util.Arrays;
import java.util.Comparator;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.Expressions;
import org.apache.flink.table.data.ArrayData;
import org.apache.flink.table.data.GenericArrayData;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.functions.BuiltInFunctionDefinitions;
import org.apache.flink.table.functions.FunctionContext;
import org.apache.flink.table.functions.SpecializedFunction;
import org.apache.flink.table.runtime.functions.scalar.BuiltInScalarFunction;
import org.apache.flink.table.types.CollectionDataType;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.util.FlinkRuntimeException;

@Internal
public class ArraySortFunction
extends BuiltInScalarFunction {
    private final ArrayData.ElementGetter elementGetter;
    private final SpecializedFunction.ExpressionEvaluator greaterEvaluator;
    private transient MethodHandle greaterHandle;

    public ArraySortFunction(SpecializedFunction.SpecializedContext context) {
        super(BuiltInFunctionDefinitions.ARRAY_SORT, context);
        DataType elementDataType = ((CollectionDataType)context.getCallContext().getArgumentDataTypes().get(0)).getElementDataType().toInternal();
        this.elementGetter = ArrayData.createElementGetter((LogicalType)elementDataType.toInternal().getLogicalType());
        this.greaterEvaluator = context.createEvaluator((Expression)Expressions.$((String)"element1").isGreater((Object)Expressions.$((String)"element2")), DataTypes.BOOLEAN(), new DataTypes.Field[]{DataTypes.FIELD((String)"element1", (DataType)((DataType)elementDataType.notNull()).toInternal()), DataTypes.FIELD((String)"element2", (DataType)((DataType)elementDataType.notNull()).toInternal())});
    }

    public void open(FunctionContext context) throws Exception {
        this.greaterHandle = this.greaterEvaluator.open(context);
    }

    @Nullable
    public ArrayData eval(ArrayData array) {
        return this.eval(array, true, true);
    }

    @Nullable
    public ArrayData eval(ArrayData array, Boolean ascendingOrder) {
        return this.eval(array, ascendingOrder, ascendingOrder);
    }

    @Nullable
    public ArrayData eval(ArrayData array, Boolean ascendingOrder, Boolean nullFirst) {
        try {
            if (array == null || ascendingOrder == null || nullFirst == null) {
                return null;
            }
            if (array.size() == 0) {
                return array;
            }
            Object[] elements = new Object[array.size()];
            for (int i = 0; i < array.size(); ++i) {
                elements[i] = this.elementGetter.getElementOrNull(array, i);
            }
            ArraySortComparator ascendingComparator = new ArraySortComparator(ascendingOrder);
            Arrays.sort(elements, nullFirst != false ? Comparator.nullsFirst(ascendingComparator) : Comparator.nullsLast(ascendingComparator));
            return new GenericArrayData(elements);
        }
        catch (Throwable t) {
            throw new FlinkRuntimeException(t);
        }
    }

    public void close() throws Exception {
        this.greaterEvaluator.close();
    }

    private class ArraySortComparator
    implements Comparator<Object> {
        private final boolean isAscending;

        public ArraySortComparator(boolean isAscending) {
            this.isAscending = isAscending;
        }

        @Override
        public int compare(Object o1, Object o2) {
            try {
                boolean isGreater = ArraySortFunction.this.greaterHandle.invoke(o1, o2);
                return this.isAscending ? (isGreater ? 1 : -1) : (isGreater ? -1 : 1);
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
    }
}

