/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.typeutils;

import java.io.Serializable;
import java.util.Comparator;
import java.util.SortedMap;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.table.runtime.typeutils.AbstractMapTypeInfo;
import org.apache.flink.table.runtime.typeutils.SortedMapSerializer;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public class SortedMapTypeInfo<K, V>
extends AbstractMapTypeInfo<K, V, SortedMap<K, V>> {
    private static final long serialVersionUID = 1L;
    private final Comparator<K> comparator;

    public SortedMapTypeInfo(TypeInformation<K> keyTypeInfo, TypeInformation<V> valueTypeInfo, Comparator<K> comparator) {
        super(keyTypeInfo, valueTypeInfo);
        Preconditions.checkNotNull(comparator, (String)"The comparator cannot be null.");
        this.comparator = comparator;
    }

    public SortedMapTypeInfo(Class<K> keyClass, Class<V> valueClass, Comparator<K> comparator) {
        super(keyClass, valueClass);
        Preconditions.checkNotNull(comparator, (String)"The comparator cannot be null.");
        this.comparator = comparator;
    }

    public SortedMapTypeInfo(Class<K> keyClass, Class<V> valueClass) {
        super(keyClass, valueClass);
        Preconditions.checkArgument((boolean)Comparable.class.isAssignableFrom(keyClass), (Object)"The key class must be comparable when no comparator is given.");
        this.comparator = new ComparableComparator();
    }

    public Class<SortedMap<K, V>> getTypeClass() {
        return SortedMap.class;
    }

    public TypeSerializer<SortedMap<K, V>> createSerializer(SerializerConfig config) {
        TypeSerializer keyTypeSerializer = this.keyTypeInfo.createSerializer(config);
        TypeSerializer valueTypeSerializer = this.valueTypeInfo.createSerializer(config);
        return new SortedMapSerializer(this.comparator, keyTypeSerializer, valueTypeSerializer);
    }

    public TypeSerializer<SortedMap<K, V>> createSerializer(ExecutionConfig config) {
        return this.createSerializer(config.getSerializerConfig());
    }

    public boolean canEqual(Object obj) {
        return null != obj && ((Object)((Object)this)).getClass() == obj.getClass();
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        SortedMapTypeInfo that = (SortedMapTypeInfo)((Object)o);
        return this.comparator.equals(that.comparator);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.comparator.hashCode();
        return result;
    }

    public String toString() {
        return "SortedMapTypeInfo{comparator=" + this.comparator + ", keyTypeInfo=" + this.getKeyTypeInfo() + ", valueTypeInfo=" + this.getValueTypeInfo() + "}";
    }

    private static class ComparableComparator<K>
    implements Comparator<K>,
    Serializable {
        private static final long serialVersionUID = 1L;

        private ComparableComparator() {
        }

        @Override
        public int compare(K obj1, K obj2) {
            return ((Comparable)obj1).compareTo(obj2);
        }

        @Override
        public boolean equals(Object o) {
            return o == this || o != null && o.getClass() == this.getClass();
        }

        public int hashCode() {
            return "ComparableComparator".hashCode();
        }
    }
}

