/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.file.testutils.catalog;

import java.io.IOException;
import java.io.UncheckedIOException;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.json.JsonReadFeature;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.flink.util.jackson.JacksonMapperFactory;

public class JsonSerdeUtil {
    private static final ObjectMapper OBJECT_MAPPER_INSTANCE = JacksonMapperFactory.createObjectMapper().configure(JsonReadFeature.ALLOW_UNESCAPED_CONTROL_CHARS.mappedFeature(), true);

    public static <T> T fromJson(String json, Class<T> clazz) {
        try {
            return (T)OBJECT_MAPPER_INSTANCE.reader().readValue(json, clazz);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static <T> String toJson(T t) {
        try {
            return OBJECT_MAPPER_INSTANCE.writerWithDefaultPrettyPrinter().writeValueAsString(t);
        }
        catch (JsonProcessingException e) {
            throw new UncheckedIOException((IOException)((Object)e));
        }
    }
}

