/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.extraction;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.java.typeutils.TypeExtractionUtils;
import org.apache.flink.table.annotation.DataTypeHint;
import org.apache.flink.table.catalog.DataTypeFactory;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.extraction.BaseMappingExtractor;
import org.apache.flink.table.types.extraction.DataTypeExtractor;
import org.apache.flink.table.types.extraction.ExtractionUtils;
import org.apache.flink.table.types.extraction.FunctionResultTemplate;
import org.apache.flink.table.types.extraction.FunctionSignatureTemplate;
import org.apache.flink.table.types.extraction.FunctionTemplate;
import org.apache.flink.table.types.extraction.TemplateUtils;
import org.apache.flink.util.Preconditions;

@Internal
final class FunctionMappingExtractor
extends BaseMappingExtractor {
    private final Class<? extends UserDefinedFunction> function;
    @Nullable
    private final BaseMappingExtractor.ResultExtraction stateExtraction;
    @Nullable
    private final BaseMappingExtractor.MethodVerification stateVerification;

    FunctionMappingExtractor(DataTypeFactory typeFactory, Class<? extends UserDefinedFunction> function, String methodName, BaseMappingExtractor.SignatureExtraction signatureExtraction, @Nullable BaseMappingExtractor.ResultExtraction stateExtraction, @Nullable BaseMappingExtractor.MethodVerification stateVerification, BaseMappingExtractor.ResultExtraction outputExtraction, @Nullable BaseMappingExtractor.MethodVerification outputVerification) {
        super(typeFactory, methodName, signatureExtraction, outputExtraction, outputVerification);
        this.function = function;
        this.stateExtraction = stateExtraction;
        this.stateVerification = stateVerification;
    }

    Map<FunctionSignatureTemplate, FunctionResultTemplate.FunctionStateTemplate> extractStateMapping() {
        Preconditions.checkState((boolean)this.supportsState());
        try {
            return this.extractResultMappings(this.stateExtraction, FunctionTemplate::getStateTemplate, this.stateVerification);
        }
        catch (Throwable t) {
            throw ExtractionUtils.extractionError(t, "Error in extracting a signature to state mapping.", new Object[0]);
        }
    }

    static BaseMappingExtractor.ResultExtraction createOutputFromReturnTypeInMethod() {
        return (extractor, method) -> {
            DataType dataType = DataTypeExtractor.extractFromMethodReturnType(extractor.typeFactory, extractor.getFunctionClass(), method);
            return FunctionResultTemplate.ofOutput(dataType);
        };
    }

    static BaseMappingExtractor.ResultExtraction createOutputFromGenericInClass(Class<? extends UserDefinedFunction> baseClass, int genericPos, boolean allowDataTypeHint) {
        return (extractor, method) -> {
            Optional<FunctionResultTemplate> hints;
            if (allowDataTypeHint && (hints = FunctionMappingExtractor.extractHints(extractor, method)).isPresent()) {
                return hints.get();
            }
            DataType dataType = DataTypeExtractor.extractFromGeneric(extractor.typeFactory, baseClass, genericPos, extractor.getFunctionClass());
            return FunctionResultTemplate.ofOutput(dataType);
        };
    }

    static BaseMappingExtractor.ResultExtraction createOutputFromGenericInMethod(int paramPos, int genericPos, boolean allowDataTypeHint) {
        return (extractor, method) -> {
            Optional<FunctionResultTemplate> hints;
            if (allowDataTypeHint && (hints = FunctionMappingExtractor.extractHints(extractor, method)).isPresent()) {
                return hints.get();
            }
            DataType dataType = DataTypeExtractor.extractFromGenericMethodParameter(extractor.typeFactory, extractor.getFunctionClass(), method, paramPos, genericPos);
            return FunctionResultTemplate.ofOutput(dataType);
        };
    }

    static BaseMappingExtractor.MethodVerification createParameterAndReturnTypeVerification() {
        return (method, state, arguments, result) -> {
            boolean isValid;
            FunctionMappingExtractor.checkNoState(state);
            FunctionMappingExtractor.checkScalarArgumentsOnly(arguments);
            Class<?>[] parameters = FunctionMappingExtractor.assembleParameters(null, arguments);
            assert (result != null);
            Class<?> resultClass = result.toClass();
            Class<?> returnType = method.getReturnType();
            boolean bl = isValid = ExtractionUtils.isInvokable(ExtractionUtils.Autoboxing.STRICT, method, parameters) && ExtractionUtils.isAssignable(resultClass, returnType, ExtractionUtils.Autoboxing.JVM);
            if (!isValid) {
                throw FunctionMappingExtractor.createMethodNotFoundError(method.getName(), parameters, resultClass, "");
            }
        };
    }

    static BaseMappingExtractor.MethodVerification createParameterVerification(boolean requireAccumulator) {
        return (method, state, arguments, result) -> {
            if (requireAccumulator) {
                FunctionMappingExtractor.checkSingleState(state);
            } else {
                FunctionMappingExtractor.checkNoState(state);
            }
            FunctionMappingExtractor.checkScalarArgumentsOnly(arguments);
            Class<?>[] parameters = FunctionMappingExtractor.assembleParameters(state, arguments);
            if (!ExtractionUtils.isInvokable(ExtractionUtils.Autoboxing.STRICT, method, parameters)) {
                throw FunctionMappingExtractor.createMethodNotFoundError(method.getName(), parameters, null, requireAccumulator ? "(<accumulator> [, <argument>]*)" : "");
            }
        };
    }

    static BaseMappingExtractor.MethodVerification createParameterAndCompletableFutureVerification(Class<?> baseClass, boolean verifyFutureContainsCollection) {
        return (method, state, arguments, result) -> {
            Type returnType;
            FunctionMappingExtractor.checkNoState(state);
            FunctionMappingExtractor.checkScalarArgumentsOnly(arguments);
            Class<?>[] parameters = FunctionMappingExtractor.assembleParameters(null, arguments);
            Class[] parametersWithFuture = (Class[])Stream.concat(Stream.of(CompletableFuture.class), Arrays.stream(parameters)).toArray(Class[]::new);
            assert (result != null);
            Class<?> resultClass = result.toClass();
            Type genericType = method.getGenericParameterTypes()[0];
            Optional parameterized = TypeExtractionUtils.getParameterizedType((Type)(genericType = ExtractionUtils.resolveVariableWithClassContext(baseClass, genericType)));
            if (!parameterized.isPresent()) {
                throw ExtractionUtils.extractionError("The method '%s' needs generic parameters for the CompletableFuture at position %d.", method.getName(), 0);
            }
            if (verifyFutureContainsCollection) {
                Type nestedGenericType = ((ParameterizedType)parameterized.get()).getActualTypeArguments()[0];
                Optional nestedParameterized = TypeExtractionUtils.getParameterizedType((Type)nestedGenericType);
                if (!nestedParameterized.isPresent() || !((ParameterizedType)nestedParameterized.get()).getRawType().equals(Collection.class)) {
                    throw ExtractionUtils.extractionError("The method '%s' expects nested generic type CompletableFuture<Collection> for the %d arg.", method.getName(), 0);
                }
                returnType = ((ParameterizedType)nestedParameterized.get()).getActualTypeArguments()[0];
            } else {
                returnType = ((ParameterizedType)parameterized.get()).getActualTypeArguments()[0];
            }
            Class<?> returnTypeClass = ExtractionUtils.getClassFromType(returnType);
            if (!ExtractionUtils.isInvokable(ExtractionUtils.Autoboxing.STRICT, method, parametersWithFuture) || !ExtractionUtils.isAssignable(resultClass, returnTypeClass, ExtractionUtils.Autoboxing.JVM)) {
                throw FunctionMappingExtractor.createMethodNotFoundError(method.getName(), parametersWithFuture, null, "(<completable future> [, <argument>]*)");
            }
        };
    }

    static BaseMappingExtractor.MethodVerification createParameterAndOptionalContextVerification(Class<?> context, boolean allowState) {
        return (method, state, arguments, result) -> {
            if (!allowState) {
                FunctionMappingExtractor.checkNoState(state);
            }
            Class<?>[] parameters = FunctionMappingExtractor.assembleParameters(state, arguments);
            Class[] parametersWithContext = (Class[])Stream.concat(Stream.of(context), Arrays.stream(parameters)).toArray(Class[]::new);
            if (!ExtractionUtils.isInvokable(ExtractionUtils.Autoboxing.STRICT, method, parameters) && !ExtractionUtils.isInvokable(ExtractionUtils.Autoboxing.STRICT, method, parametersWithContext)) {
                throw FunctionMappingExtractor.createMethodNotFoundError(method.getName(), parameters, null, allowState ? "(<context>? [, <state>]* [, <argument>]*)" : "");
            }
        };
    }

    Class<? extends UserDefinedFunction> getFunction() {
        return this.function;
    }

    boolean supportsState() {
        return this.stateExtraction != null;
    }

    @Override
    protected Set<FunctionTemplate> extractGlobalFunctionTemplates() {
        return TemplateUtils.extractGlobalFunctionTemplates(this.typeFactory, this.function);
    }

    @Override
    protected Set<FunctionTemplate> extractLocalFunctionTemplates(Method method) {
        return TemplateUtils.extractLocalFunctionTemplates(this.typeFactory, method);
    }

    @Override
    protected List<Method> collectMethods(String methodName) {
        return ExtractionUtils.collectMethods(this.function, methodName);
    }

    @Override
    protected Class<?> getFunctionClass() {
        return this.function;
    }

    @Override
    protected String getHintType() {
        return "Function";
    }

    private static Optional<FunctionResultTemplate> extractHints(BaseMappingExtractor extractor, Method method) {
        HashSet<DataTypeHint> dataTypeHints = new HashSet<DataTypeHint>();
        dataTypeHints.addAll(ExtractionUtils.collectAnnotationsOfMethod(DataTypeHint.class, method));
        dataTypeHints.addAll(ExtractionUtils.collectAnnotationsOfClass(DataTypeHint.class, extractor.getFunctionClass()));
        if (dataTypeHints.size() > 1) {
            throw ExtractionUtils.extractionError("More than one data type hint found for output of function. Please use a function hint instead.", new Object[0]);
        }
        if (dataTypeHints.size() == 1) {
            return Optional.ofNullable(FunctionTemplate.createOutputTemplate(extractor.typeFactory, (DataTypeHint)dataTypeHints.iterator().next()));
        }
        return Optional.empty();
    }
}

