/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.functions;

import java.util.Optional;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.OverWindowRange;
import org.apache.flink.table.expressions.ResolvedExpression;
import org.apache.flink.table.expressions.TableSymbol;
import org.apache.flink.table.expressions.ValueLiteralExpression;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeFamily;
import org.apache.flink.table.types.logical.LogicalTypeRoot;

@Internal
class CallSyntaxUtils {
    static String asSerializableOperand(ResolvedExpression expression) {
        if (expression.getResolvedChildren().isEmpty()) {
            return expression.asSerializableString();
        }
        return String.format("(%s)", expression.asSerializableString());
    }

    static <T extends TableSymbol> T getSymbolLiteral(ResolvedExpression operands, Class<T> clazz) {
        return (T)((TableSymbol)((ValueLiteralExpression)operands).getValueAs(clazz).get());
    }

    static String overRangeToSerializableString(ResolvedExpression preceding, ResolvedExpression following) {
        if (((ValueLiteralExpression)preceding).isNull() || ((ValueLiteralExpression)following).isNull()) {
            return "";
        }
        return String.format(" %s BETWEEN %s AND %s", CallSyntaxUtils.isRowsRange(preceding) ? "ROWS" : "RANGE", CallSyntaxUtils.toStringPrecedingOrFollowing(preceding, true), CallSyntaxUtils.toStringPrecedingOrFollowing(following, false));
    }

    private static String toStringPrecedingOrFollowing(ResolvedExpression precedingOrFollowing, boolean isPreceding) {
        String suffix = isPreceding ? "PRECEDING" : "FOLLOWING";
        return Optional.of(precedingOrFollowing).flatMap(expr -> {
            if (expr instanceof ValueLiteralExpression) {
                return ((ValueLiteralExpression)expr).getValueAs(OverWindowRange.class).map(r -> {
                    switch (r) {
                        case CURRENT_ROW: 
                        case CURRENT_RANGE: {
                            return "CURRENT ROW";
                        }
                        case UNBOUNDED_ROW: 
                        case UNBOUNDED_RANGE: {
                            return "UNBOUNDED " + suffix;
                        }
                    }
                    throw new IllegalStateException("Unknown window range: " + r);
                });
            }
            return Optional.empty();
        }).orElseGet(() -> precedingOrFollowing.asSerializableString() + " " + suffix);
    }

    private static boolean isRowsRange(ResolvedExpression expression) {
        LogicalType logicalType = expression.getOutputDataType().getLogicalType();
        boolean isSymbol = logicalType.is(LogicalTypeRoot.SYMBOL);
        if (isSymbol) {
            OverWindowRange windowRange = CallSyntaxUtils.getSymbolLiteral(expression, OverWindowRange.class);
            return windowRange == OverWindowRange.CURRENT_ROW || windowRange == OverWindowRange.UNBOUNDED_ROW;
        }
        return logicalType.is(LogicalTypeFamily.NUMERIC);
    }

    private CallSyntaxUtils() {
    }
}

