/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.catalog;

import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.catalog.CatalogModel;
import org.apache.flink.util.Preconditions;

@Internal
public class DefaultCatalogModel
implements CatalogModel {
    private final Schema inputSchema;
    private final Schema outputSchema;
    private final Map<String, String> modelOptions;
    @Nullable
    private final String comment;

    protected DefaultCatalogModel(Schema inputSchema, Schema outputSchema, Map<String, String> modelOptions, @Nullable String comment) {
        this.inputSchema = (Schema)Preconditions.checkNotNull((Object)inputSchema, (String)"Input schema must not be null.");
        this.outputSchema = (Schema)Preconditions.checkNotNull((Object)outputSchema, (String)"Output schema must not be null.");
        this.modelOptions = modelOptions;
        this.comment = comment;
    }

    @Override
    public Map<String, String> getOptions() {
        return this.modelOptions;
    }

    @Override
    public Schema getInputSchema() {
        return this.inputSchema;
    }

    @Override
    public Schema getOutputSchema() {
        return this.outputSchema;
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    @Override
    public CatalogModel copy() {
        return new DefaultCatalogModel(this.inputSchema, this.outputSchema, this.modelOptions, this.comment);
    }

    @Override
    public CatalogModel copy(Map<String, String> newModelOptions) {
        return new DefaultCatalogModel(this.inputSchema, this.outputSchema, newModelOptions, this.comment);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultCatalogModel that = (DefaultCatalogModel)o;
        return Objects.equals(this.inputSchema, that.inputSchema) && Objects.equals(this.outputSchema, that.outputSchema) && this.modelOptions.equals(that.modelOptions) && Objects.equals(this.comment, that.comment);
    }

    public int hashCode() {
        return Objects.hash(this.inputSchema, this.outputSchema, this.modelOptions, this.comment);
    }

    public String toString() {
        return "DefaultCatalogModel{inputSchema=" + this.inputSchema + ", outputSchema=" + this.outputSchema + ", modelOptions=" + this.modelOptions + ", comment=" + this.comment + "}";
    }
}

