/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.catalog;

import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.serialization.SerializerConfigImpl;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.runtime.kryo.KryoSerializer;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.DataTypeFactory;
import org.apache.flink.table.catalog.UnresolvedIdentifier;
import org.apache.flink.table.types.AbstractDataType;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.UnresolvedDataType;
import org.apache.flink.table.types.extraction.DataTypeExtractor;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.utils.LogicalTypeChecks;
import org.apache.flink.table.types.logical.utils.LogicalTypeParser;
import org.apache.flink.table.types.utils.TypeConversions;
import org.apache.flink.table.types.utils.TypeInfoDataTypeConverter;

@Internal
final class DataTypeFactoryImpl
implements DataTypeFactory {
    private final ClassLoader classLoader;
    private final Supplier<SerializerConfig> serializerConfig;

    DataTypeFactoryImpl(ClassLoader classLoader, ReadableConfig config, @Nullable SerializerConfig serializerConfig) {
        this.classLoader = classLoader;
        this.serializerConfig = DataTypeFactoryImpl.createSerializerConfig(classLoader, config, serializerConfig);
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public DataType createDataType(AbstractDataType<?> abstractDataType) {
        if (abstractDataType instanceof DataType) {
            return (DataType)abstractDataType;
        }
        if (abstractDataType instanceof UnresolvedDataType) {
            return ((UnresolvedDataType)abstractDataType).toDataType((DataTypeFactory)this);
        }
        throw new ValidationException("Unsupported abstract data type.");
    }

    public DataType createDataType(String typeString) {
        return TypeConversions.fromLogicalToDataType((LogicalType)this.createLogicalType(typeString));
    }

    public DataType createDataType(UnresolvedIdentifier identifier) {
        return TypeConversions.fromLogicalToDataType((LogicalType)this.createLogicalType(identifier));
    }

    public <T> DataType createDataType(Class<T> clazz) {
        return DataTypeExtractor.extractFromType((DataTypeFactory)this, clazz);
    }

    public <T> DataType createDataType(TypeInformation<T> typeInfo) {
        return TypeInfoDataTypeConverter.toDataType((DataTypeFactory)this, typeInfo);
    }

    public <T> DataType createRawDataType(Class<T> clazz) {
        return DataTypes.RAW(clazz, (TypeSerializer)new KryoSerializer(clazz, this.serializerConfig.get()));
    }

    public <T> DataType createRawDataType(TypeInformation<T> typeInfo) {
        return DataTypes.RAW((Class)typeInfo.getTypeClass(), (TypeSerializer)typeInfo.createSerializer(this.serializerConfig.get()));
    }

    public LogicalType createLogicalType(String typeString) {
        LogicalType parsedType = LogicalTypeParser.parse((String)typeString, (ClassLoader)this.classLoader);
        if (LogicalTypeChecks.hasNested((LogicalType)parsedType, t -> t.is(LogicalTypeRoot.UNRESOLVED))) {
            throw this.unsupportedUserDefinedTypes();
        }
        return parsedType;
    }

    public LogicalType createLogicalType(UnresolvedIdentifier identifier) {
        if (identifier.getDatabaseName().isEmpty()) {
            return this.createLogicalType(identifier.getObjectName());
        }
        throw this.unsupportedUserDefinedTypes();
    }

    private static Supplier<SerializerConfig> createSerializerConfig(ClassLoader classLoader, ReadableConfig config, SerializerConfig serializerConfig) {
        return () -> {
            SerializerConfig newSerializerConfig;
            if (serializerConfig != null) {
                newSerializerConfig = serializerConfig.copy();
            } else {
                newSerializerConfig = new SerializerConfigImpl();
                newSerializerConfig.configure(config, classLoader);
            }
            return newSerializerConfig;
        };
    }

    private TableException unsupportedUserDefinedTypes() {
        return new TableException("User-defined types are not supported yet.");
    }
}

