/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.loader;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Stream;
import org.apache.flink.annotation.Internal;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ConfigurationUtils;
import org.apache.flink.configuration.CoreOptions;
import org.apache.flink.core.classloading.ComponentClassLoader;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.delegation.ExecutorFactory;
import org.apache.flink.table.delegation.PlannerFactory;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.util.FileUtils;
import org.apache.flink.util.IOUtils;

@Internal
public class PlannerModule {
    static final String FLINK_TABLE_PLANNER_FAT_JAR = "flink-table-planner.jar";
    private static final String HINT_USAGE = "mvn clean package -pl flink-table/flink-table-planner,flink-table/flink-table-planner-loader -DskipTests";
    private static final String[] OWNER_CLASSPATH = (String[])Stream.concat(Arrays.stream(CoreOptions.PARENT_FIRST_LOGGING_PATTERNS), Stream.of("org.codehaus.janino", "org.codehaus.commons", "org.apache.commons.lang3", "org.apache.commons.math3", "org.apache.commons.text", "org.apache.hadoop")).toArray(String[]::new);
    private static final String[] COMPONENT_CLASSPATH = new String[]{"org.apache.flink"};
    private static final Map<String, String> KNOWN_MODULE_ASSOCIATIONS = new HashMap<String, String>();
    private final PlannerComponentClassLoader submoduleClassLoader;

    private PlannerModule() {
        try {
            ClassLoader flinkClassLoader = PlannerModule.class.getClassLoader();
            Path tmpDirectory = Paths.get(ConfigurationUtils.parseTempDirectories((Configuration)new Configuration())[0], new String[0]);
            Files.createDirectories(FileUtils.getTargetPathIfContainsSymbolicPath((Path)tmpDirectory), new FileAttribute[0]);
            Path tempFile = Files.createFile(tmpDirectory.resolve("flink-table-planner_" + UUID.randomUUID() + ".jar"), new FileAttribute[0]);
            InputStream resourceStream = flinkClassLoader.getResourceAsStream(FLINK_TABLE_PLANNER_FAT_JAR);
            if (resourceStream == null) {
                throw new TableException(String.format("Flink Table planner could not be found. If this happened while running a test in the IDE, run '%s' on the command-line, or add a test dependency on the flink-table-planner-loader test-jar.", HINT_USAGE));
            }
            IOUtils.copyBytes((InputStream)resourceStream, (OutputStream)Files.newOutputStream(tempFile, new OpenOption[0]));
            tempFile.toFile().deleteOnExit();
            this.submoduleClassLoader = new PlannerComponentClassLoader(new URL[]{tempFile.toUri().toURL()}, flinkClassLoader, OWNER_CLASSPATH, COMPONENT_CLASSPATH, KNOWN_MODULE_ASSOCIATIONS);
        }
        catch (IOException e) {
            throw new TableException("Could not initialize the table planner components loader.", (Throwable)e);
        }
    }

    public ClassLoader getSubmoduleClassLoader() {
        return this.submoduleClassLoader;
    }

    public void addUrlToClassLoader(URL url) {
        this.submoduleClassLoader.addURL(url);
    }

    public static PlannerModule getInstance() {
        return PlannerComponentsHolder.INSTANCE;
    }

    public ExecutorFactory loadExecutorFactory() {
        return (ExecutorFactory)FactoryUtil.discoverFactory((ClassLoader)((Object)this.submoduleClassLoader), ExecutorFactory.class, (String)"default");
    }

    public PlannerFactory loadPlannerFactory() {
        return (PlannerFactory)FactoryUtil.discoverFactory((ClassLoader)((Object)this.submoduleClassLoader), PlannerFactory.class, (String)"default");
    }

    static {
        KNOWN_MODULE_ASSOCIATIONS.put("org.apache.flink.table.runtime", "flink-table-runtime");
        KNOWN_MODULE_ASSOCIATIONS.put("org.apache.flink.formats.raw", "flink-table-runtime");
        KNOWN_MODULE_ASSOCIATIONS.put("org.codehaus.janino", "flink-table-runtime");
        KNOWN_MODULE_ASSOCIATIONS.put("org.codehaus.commons", "flink-table-runtime");
        KNOWN_MODULE_ASSOCIATIONS.put("org.apache.flink.table.shaded.com.jayway", "flink-table-runtime");
    }

    private static class PlannerComponentClassLoader
    extends ComponentClassLoader {
        public PlannerComponentClassLoader(URL[] classpath, ClassLoader ownerClassLoader, String[] ownerFirstPackages, String[] componentFirstPackages, Map<String, String> knownPackagePrefixesModuleAssociation) {
            super(classpath, ownerClassLoader, ownerFirstPackages, componentFirstPackages, knownPackagePrefixesModuleAssociation);
        }

        public void addURL(URL url) {
            super.addURL(url);
        }
    }

    private static class PlannerComponentsHolder {
        private static final PlannerModule INSTANCE = new PlannerModule();

        private PlannerComponentsHolder() {
        }
    }
}

