/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.operations;

import java.util.Objects;
import java.util.stream.Stream;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.internal.TableResultInternal;
import org.apache.flink.table.api.internal.TableResultUtils;
import org.apache.flink.table.functions.SqlLikeUtils;
import org.apache.flink.table.operations.ExecutableOperation;
import org.apache.flink.table.operations.LikeType;
import org.apache.flink.table.operations.ShowOperation;

@Internal
public class ShowDatabasesOperation
implements ShowOperation {
    private final String catalogName;
    private final LikeType likeType;
    private final String likePattern;
    private final boolean notLike;

    public ShowDatabasesOperation() {
        this(null, null, null, false);
    }

    public ShowDatabasesOperation(String likeType, String likePattern, boolean notLike) {
        this(null, likeType, likePattern, notLike);
    }

    public ShowDatabasesOperation(String catalogName, String likeType, String likePattern, boolean notLike) {
        this.catalogName = catalogName;
        if (likeType != null) {
            this.likeType = LikeType.of(likeType);
            this.likePattern = Objects.requireNonNull(likePattern, "Like pattern must not be null");
            this.notLike = notLike;
        } else {
            this.likeType = null;
            this.likePattern = null;
            this.notLike = false;
        }
    }

    @Override
    public String asSummaryString() {
        StringBuilder builder = new StringBuilder();
        builder.append("SHOW DATABASES");
        if (this.catalogName != null) {
            builder.append(String.format(" FROM/IN %s", this.catalogName));
        }
        if (this.likeType != null) {
            if (this.notLike) {
                builder.append(String.format(" NOT %s '%s'", this.likeType.name(), this.likePattern));
            } else {
                builder.append(String.format(" %s '%s'", this.likeType.name(), this.likePattern));
            }
        }
        return builder.toString();
    }

    @Override
    public TableResultInternal execute(ExecutableOperation.Context ctx) {
        String cName = this.catalogName == null ? ctx.getCatalogManager().getCurrentCatalog() : this.catalogName;
        Stream<Object> databases = ctx.getCatalogManager().getCatalogOrThrowException(cName).listDatabases().stream();
        if (this.likeType != null) {
            databases = databases.filter(row -> {
                if (this.likeType == LikeType.ILIKE) {
                    return this.notLike != SqlLikeUtils.ilike(row, this.likePattern, "\\");
                }
                if (this.likeType == LikeType.LIKE) {
                    return this.notLike != SqlLikeUtils.like(row, this.likePattern, "\\");
                }
                return false;
            });
        }
        return TableResultUtils.buildStringArrayResult("database name", (String[])databases.sorted().toArray(String[]::new));
    }
}

