/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.catalog;

import java.util.Objects;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.table.expressions.ResolvedExpression;
import org.apache.flink.table.utils.EncodingUtils;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public final class WatermarkSpec {
    private final String rowtimeAttribute;
    private final ResolvedExpression watermarkExpression;

    private WatermarkSpec(String rowtimeAttribute, ResolvedExpression watermarkExpression) {
        this.rowtimeAttribute = (String)Preconditions.checkNotNull((Object)rowtimeAttribute, (String)"Rowtime attribute must not be null.");
        this.watermarkExpression = (ResolvedExpression)Preconditions.checkNotNull((Object)watermarkExpression, (String)"Watermark expression must not be null.");
    }

    public static WatermarkSpec of(String rowtimeAttribute, ResolvedExpression watermarkExpression) {
        return new WatermarkSpec(rowtimeAttribute, watermarkExpression);
    }

    public String getRowtimeAttribute() {
        return this.rowtimeAttribute;
    }

    public ResolvedExpression getWatermarkExpression() {
        return this.watermarkExpression;
    }

    public String asSummaryString() {
        return "WATERMARK FOR " + EncodingUtils.escapeIdentifier(this.rowtimeAttribute) + ": " + String.valueOf(this.watermarkExpression.getOutputDataType()) + " AS " + this.watermarkExpression.asSummaryString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WatermarkSpec that = (WatermarkSpec)o;
        return this.rowtimeAttribute.equals(that.rowtimeAttribute) && this.watermarkExpression.equals(that.watermarkExpression);
    }

    public int hashCode() {
        return Objects.hash(this.rowtimeAttribute, this.watermarkExpression);
    }

    public String toString() {
        return this.asSummaryString();
    }
}

