/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.data;

import java.io.Serializable;
import javax.annotation.Nullable;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.table.data.ArrayData;
import org.apache.flink.table.data.DecimalData;
import org.apache.flink.table.data.MapData;
import org.apache.flink.table.data.RawValueData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.types.logical.DistinctType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.utils.LogicalTypeChecks;
import org.apache.flink.types.RowKind;
import org.apache.flink.types.variant.Variant;

@PublicEvolving
public interface RowData {
    public int getArity();

    public RowKind getRowKind();

    public void setRowKind(RowKind var1);

    public boolean isNullAt(int var1);

    public boolean getBoolean(int var1);

    public byte getByte(int var1);

    public short getShort(int var1);

    public int getInt(int var1);

    public long getLong(int var1);

    public float getFloat(int var1);

    public double getDouble(int var1);

    public StringData getString(int var1);

    public DecimalData getDecimal(int var1, int var2, int var3);

    public TimestampData getTimestamp(int var1, int var2);

    public <T> RawValueData<T> getRawValue(int var1);

    public byte[] getBinary(int var1);

    public ArrayData getArray(int var1);

    public MapData getMap(int var1);

    public RowData getRow(int var1, int var2);

    public Variant getVariant(int var1);

    public static FieldGetter createFieldGetter(LogicalType fieldType, int fieldPos) {
        FieldGetter fieldGetter;
        switch (fieldType.getTypeRoot()) {
            case CHAR: 
            case VARCHAR: {
                fieldGetter = row -> row.getString(fieldPos);
                break;
            }
            case BOOLEAN: {
                fieldGetter = row -> row.getBoolean(fieldPos);
                break;
            }
            case BINARY: 
            case VARBINARY: {
                fieldGetter = row -> row.getBinary(fieldPos);
                break;
            }
            case DECIMAL: {
                int decimalPrecision = LogicalTypeChecks.getPrecision(fieldType);
                int decimalScale = LogicalTypeChecks.getScale(fieldType);
                fieldGetter = row -> row.getDecimal(fieldPos, decimalPrecision, decimalScale);
                break;
            }
            case TINYINT: {
                fieldGetter = row -> row.getByte(fieldPos);
                break;
            }
            case SMALLINT: {
                fieldGetter = row -> row.getShort(fieldPos);
                break;
            }
            case INTEGER: 
            case DATE: 
            case TIME_WITHOUT_TIME_ZONE: 
            case INTERVAL_YEAR_MONTH: {
                fieldGetter = row -> row.getInt(fieldPos);
                break;
            }
            case BIGINT: 
            case INTERVAL_DAY_TIME: {
                fieldGetter = row -> row.getLong(fieldPos);
                break;
            }
            case FLOAT: {
                fieldGetter = row -> Float.valueOf(row.getFloat(fieldPos));
                break;
            }
            case DOUBLE: {
                fieldGetter = row -> row.getDouble(fieldPos);
                break;
            }
            case TIMESTAMP_WITHOUT_TIME_ZONE: 
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                int timestampPrecision = LogicalTypeChecks.getPrecision(fieldType);
                fieldGetter = row -> row.getTimestamp(fieldPos, timestampPrecision);
                break;
            }
            case TIMESTAMP_WITH_TIME_ZONE: {
                throw new UnsupportedOperationException();
            }
            case ARRAY: {
                fieldGetter = row -> row.getArray(fieldPos);
                break;
            }
            case MULTISET: 
            case MAP: {
                fieldGetter = row -> row.getMap(fieldPos);
                break;
            }
            case ROW: 
            case STRUCTURED_TYPE: {
                int rowFieldCount = LogicalTypeChecks.getFieldCount(fieldType);
                fieldGetter = row -> row.getRow(fieldPos, rowFieldCount);
                break;
            }
            case DISTINCT_TYPE: {
                fieldGetter = RowData.createFieldGetter(((DistinctType)fieldType).getSourceType(), fieldPos);
                break;
            }
            case RAW: {
                fieldGetter = row -> row.getRawValue(fieldPos);
                break;
            }
            case VARIANT: {
                fieldGetter = row -> row.getVariant(fieldPos);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return row -> {
            if (row.isNullAt(fieldPos)) {
                return null;
            }
            return fieldGetter.getFieldOrNull(row);
        };
    }

    @PublicEvolving
    public static interface FieldGetter
    extends Serializable {
        @Nullable
        public Object getFieldOrNull(RowData var1);
    }
}

