/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.operations.materializedtable;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.internal.TableResultImpl;
import org.apache.flink.table.api.internal.TableResultInternal;
import org.apache.flink.table.catalog.CatalogMaterializedTable;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.TableChange;
import org.apache.flink.table.operations.ExecutableOperation;
import org.apache.flink.table.operations.ddl.AlterTableChangeOperation;
import org.apache.flink.table.operations.materializedtable.AlterMaterializedTableOperation;

@Internal
public class AlterMaterializedTableChangeOperation
extends AlterMaterializedTableOperation {
    private final List<TableChange> tableChanges;
    private final CatalogMaterializedTable catalogMaterializedTable;

    public AlterMaterializedTableChangeOperation(ObjectIdentifier tableIdentifier, List<TableChange> tableChanges, CatalogMaterializedTable catalogMaterializedTable) {
        super(tableIdentifier);
        this.tableChanges = tableChanges;
        this.catalogMaterializedTable = catalogMaterializedTable;
    }

    public List<TableChange> getTableChanges() {
        return this.tableChanges;
    }

    public CatalogMaterializedTable getCatalogMaterializedTable() {
        return this.catalogMaterializedTable;
    }

    @Override
    public TableResultInternal execute(ExecutableOperation.Context ctx) {
        ctx.getCatalogManager().alterTable(this.getCatalogMaterializedTable(), this.getTableChanges().stream().map(TableChange.class::cast).collect(Collectors.toList()), this.getTableIdentifier(), false);
        return TableResultImpl.TABLE_RESULT_OK;
    }

    @Override
    public String asSummaryString() {
        String changes = this.tableChanges.stream().map(tableChange -> {
            if (tableChange instanceof TableChange.MaterializedTableChange) {
                return this.toString((TableChange.MaterializedTableChange)tableChange);
            }
            return AlterTableChangeOperation.toString(tableChange);
        }).collect(Collectors.joining(",\n"));
        return String.format("ALTER MATERIALIZED TABLE %s\n%s", this.tableIdentifier.asSummaryString(), changes);
    }

    private String toString(TableChange.MaterializedTableChange tableChange) {
        if (tableChange instanceof TableChange.ModifyRefreshStatus) {
            TableChange.ModifyRefreshStatus refreshStatus = (TableChange.ModifyRefreshStatus)tableChange;
            return String.format("  MODIFY REFRESH STATUS TO '%s'", new Object[]{refreshStatus.getRefreshStatus()});
        }
        if (tableChange instanceof TableChange.ModifyRefreshHandler) {
            TableChange.ModifyRefreshHandler refreshHandler = (TableChange.ModifyRefreshHandler)tableChange;
            return String.format("  MODIFY REFRESH HANDLER DESCRIPTION TO '%s'", refreshHandler.getRefreshHandlerDesc());
        }
        throw new UnsupportedOperationException(String.format("Unknown materialized table change: %s.", tableChange));
    }
}

