/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.windowing.assigners;

import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.streaming.api.windowing.assigners.DynamicProcessingTimeSessionWindows;
import org.apache.flink.streaming.api.windowing.assigners.MergingWindowAssigner;
import org.apache.flink.streaming.api.windowing.assigners.SessionWindowTimeGapExtractor;
import org.apache.flink.streaming.api.windowing.assigners.WindowAssigner;
import org.apache.flink.streaming.api.windowing.triggers.ProcessingTimeTrigger;
import org.apache.flink.streaming.api.windowing.triggers.Trigger;
import org.apache.flink.streaming.api.windowing.windows.TimeWindow;

@PublicEvolving
public class ProcessingTimeSessionWindows
extends MergingWindowAssigner<Object, TimeWindow> {
    private static final long serialVersionUID = 1L;
    protected long sessionTimeout;

    protected ProcessingTimeSessionWindows(long sessionTimeout) {
        if (sessionTimeout <= 0L) {
            throw new IllegalArgumentException("ProcessingTimeSessionWindows parameters must satisfy 0 < size");
        }
        this.sessionTimeout = sessionTimeout;
    }

    public Collection<TimeWindow> assignWindows(Object element, long timestamp, WindowAssigner.WindowAssignerContext context) {
        long currentProcessingTime = context.getCurrentProcessingTime();
        return Collections.singletonList(new TimeWindow(currentProcessingTime, currentProcessingTime + this.sessionTimeout));
    }

    public Trigger<Object, TimeWindow> getDefaultTrigger() {
        return ProcessingTimeTrigger.create();
    }

    public String toString() {
        return "ProcessingTimeSessionWindows(" + this.sessionTimeout + ")";
    }

    public static ProcessingTimeSessionWindows withGap(Duration size) {
        return new ProcessingTimeSessionWindows(size.toMillis());
    }

    @PublicEvolving
    public static <T> DynamicProcessingTimeSessionWindows<T> withDynamicGap(SessionWindowTimeGapExtractor<T> sessionWindowTimeGapExtractor) {
        return new DynamicProcessingTimeSessionWindows<T>(sessionWindowTimeGapExtractor);
    }

    public TypeSerializer<TimeWindow> getWindowSerializer(ExecutionConfig executionConfig) {
        return new TimeWindow.Serializer();
    }

    public boolean isEventTime() {
        return false;
    }

    public void mergeWindows(Collection<TimeWindow> windows, MergingWindowAssigner.MergeCallback<TimeWindow> c) {
        TimeWindow.mergeWindows(windows, c);
    }
}

