/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.datastream;

import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.transformations.CacheTransformation;

@PublicEvolving
public class CachedDataStream<T>
extends DataStream<T> {
    public CachedDataStream(StreamExecutionEnvironment environment, Transformation<T> transformation) {
        super(environment, new CacheTransformation<T>(transformation, String.format("Cache: %s", transformation.getName())));
        CacheTransformation t = (CacheTransformation)this.getTransformation();
        environment.registerCacheTransformation(t.getDatasetId(), t);
    }

    public void invalidate() throws Exception {
        CacheTransformation t = (CacheTransformation)this.getTransformation();
        this.environment.invalidateClusterDataset(t.getDatasetId());
    }
}

