/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.rocksdb.sstmerge;

import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import org.apache.flink.util.Preconditions;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.RocksDBException;

class ColumnFamilyLookup {
    private final Map<Key, ColumnFamilyHandle> map = new ConcurrentHashMap<Key, ColumnFamilyHandle>();

    @Nullable
    public ColumnFamilyHandle get(byte[] name) {
        return this.map.get(new Key(name));
    }

    public void add(ColumnFamilyHandle handle) {
        try {
            this.map.put(new Key(handle.getName()), handle);
        }
        catch (RocksDBException e) {
            throw new RuntimeException(e);
        }
    }

    private static class Key {
        private final byte[] payload;

        private Key(byte[] payload) {
            this.payload = (byte[])Preconditions.checkNotNull((Object)payload);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            return Arrays.equals(this.payload, key.payload);
        }

        public int hashCode() {
            return Arrays.hashCode(this.payload);
        }
    }
}

