/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.rocksdb.sstmerge;

import java.util.function.Function;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.flink.state.rocksdb.sstmerge.RocksDBManualCompactionConfig;
import org.apache.flink.util.function.RunnableWithException;
import org.rocksdb.ColumnFamilyHandle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
class CompactionTracker {
    private static final Logger LOG = LoggerFactory.getLogger(CompactionTracker.class);
    private final Function<ColumnFamilyHandle, Long> runningAutoCompactions;
    private final int maxManualCompactions;
    private final int maxAutoCompactions;
    private int pendingManualCompactions;
    private int runningManualCompactions;
    private boolean isShuttingDown;

    public CompactionTracker(RocksDBManualCompactionConfig settings, Function<ColumnFamilyHandle, Long> runningAutoCompactions) {
        this.maxManualCompactions = settings.maxManualCompactions;
        this.maxAutoCompactions = settings.maxAutoCompactions;
        this.runningAutoCompactions = runningAutoCompactions;
        this.isShuttingDown = false;
    }

    private synchronized void complete() {
        --this.runningManualCompactions;
    }

    private synchronized void cancel() {
        --this.pendingManualCompactions;
    }

    private synchronized boolean tryStart(ColumnFamilyHandle cf) {
        if (this.runningManualCompactions >= this.maxManualCompactions) {
            return false;
        }
        if (this.isShuttingDown()) {
            return false;
        }
        if (this.runningAutoCompactions.apply(cf) >= (long)this.maxAutoCompactions) {
            return false;
        }
        --this.pendingManualCompactions;
        ++this.runningManualCompactions;
        return true;
    }

    private synchronized void runIfNoManualCompactions(Runnable runnable) {
        if (!this.haveManualCompactions()) {
            runnable.run();
        }
    }

    public synchronized boolean haveManualCompactions() {
        return this.runningManualCompactions > 0 || this.pendingManualCompactions > 0;
    }

    public synchronized boolean isShuttingDown() {
        return this.isShuttingDown;
    }

    public synchronized void close() {
        this.isShuttingDown = true;
    }

    public String toString() {
        return "CompactionTracker{maxManualCompactions=" + this.maxManualCompactions + ", maxAutoCompactions=" + this.maxAutoCompactions + ", pendingManualCompactions=" + this.pendingManualCompactions + ", runningManualCompactions=" + this.runningManualCompactions + ", isShuttingDown=" + this.isShuttingDown + "}";
    }

    void runWithTracking(ColumnFamilyHandle columnFamily, RunnableWithException compaction, Runnable lastCompactionPostAction) {
        if (this.tryStart(columnFamily)) {
            try {
                compaction.run();
            }
            catch (Exception e) {
                LOG.warn("Unable to compact {} (concurrent compaction?)", (Object)compaction, (Object)e);
            }
            this.complete();
        } else {
            this.cancel();
        }
        this.runIfNoManualCompactions(lastCompactionPostAction);
    }
}

