/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.rocksdb.iterator;

import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.core.memory.DataInputDeserializer;
import org.apache.flink.runtime.state.CompositeKeySerializationUtils;
import org.apache.flink.state.rocksdb.RocksIteratorWrapper;
import org.apache.flink.state.rocksdb.iterator.AbstractRocksStateKeysIterator;
import org.apache.flink.util.FlinkRuntimeException;

public class RocksMultiStateKeysIterator<K>
implements AutoCloseable,
Iterator<K> {
    private final List<RocksIteratorWrapper> iterators;
    private final List<String> states;
    private final TypeSerializer<K> keySerializer;
    private final List<Boolean> ambiguousKeyPossibles;
    private final int keyGroupPrefixBytes;
    private final byte[] namespaceBytes;
    private final DataInputDeserializer byteArrayDataInputView;
    private final byte[][] iteratorKeys;
    private final int[] iteratorKeysToRemove;
    private K previousKey;
    private K nextKey;

    public RocksMultiStateKeysIterator(List<RocksIteratorWrapper> iterators, List<String> states, @Nonnull TypeSerializer<K> keySerializer, int keyGroupPrefixBytes, List<Boolean> ambiguousKeyPossibles, @Nonnull byte[] namespaceBytes) {
        this.iterators = iterators;
        this.states = states;
        this.keySerializer = keySerializer;
        this.ambiguousKeyPossibles = ambiguousKeyPossibles;
        this.keyGroupPrefixBytes = keyGroupPrefixBytes;
        this.namespaceBytes = namespaceBytes;
        this.byteArrayDataInputView = new DataInputDeserializer();
        this.iteratorKeys = new byte[iterators.size()][];
        Arrays.fill((Object[])this.iteratorKeys, null);
        this.iteratorKeysToRemove = new int[iterators.size()];
        Arrays.fill(this.iteratorKeysToRemove, -1);
        this.previousKey = null;
        this.nextKey = null;
    }

    @Override
    public boolean hasNext() {
        try {
            while (this.nextKey == null && this.hasDataToProcess()) {
                this.pullKeysFromIterators();
                K smallestIteratorKey = this.calculateSmallestKeyFromLocalData();
                if (smallestIteratorKey == null) continue;
                this.previousKey = smallestIteratorKey;
                this.nextKey = smallestIteratorKey;
            }
        }
        catch (Exception e) {
            throw new FlinkRuntimeException("Failed to access states [" + String.join((CharSequence)",", this.states) + "]", (Throwable)e);
        }
        return this.nextKey != null;
    }

    private boolean hasDataToProcess() {
        boolean result = this.iterators.stream().anyMatch(RocksIteratorWrapper::isValid);
        if (!result) {
            for (int i = 0; i < this.iterators.size(); ++i) {
                if (this.iteratorKeys[i] == null) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    private void pullKeysFromIterators() {
        for (int i = 0; i < this.iterators.size(); ++i) {
            RocksIteratorWrapper iterator = this.iterators.get(i);
            if (this.iteratorKeys[i] != null || !iterator.isValid()) continue;
            this.iteratorKeys[i] = iterator.key();
            iterator.next();
        }
    }

    @Nullable
    private K calculateSmallestKeyFromLocalData() throws IOException {
        int i;
        int smallestIteratorKeyIndex = -1;
        byte[] smallestIteratorKey = null;
        int iteratorKeysToRemoveIndex = 0;
        for (i = 0; i < this.iteratorKeys.length; ++i) {
            boolean update;
            byte[] iteratorKey = this.iteratorKeys[i];
            if (iteratorKey == null) continue;
            boolean bl = update = smallestIteratorKey == null;
            if (!update) {
                int cmp = Arrays.compare(iteratorKey, smallestIteratorKey);
                if (cmp < 0) {
                    update = true;
                } else if (cmp == 0) {
                    this.iteratorKeysToRemove[iteratorKeysToRemoveIndex++] = i;
                }
            }
            if (!update) continue;
            smallestIteratorKeyIndex = i;
            smallestIteratorKey = iteratorKey;
            Arrays.fill(this.iteratorKeysToRemove, -1);
            iteratorKeysToRemoveIndex = 0;
            this.iteratorKeysToRemove[iteratorKeysToRemoveIndex++] = i;
        }
        if (smallestIteratorKey != null) {
            for (i = 0; i < iteratorKeysToRemoveIndex; ++i) {
                this.iteratorKeys[this.iteratorKeysToRemove[i]] = null;
            }
            this.byteArrayDataInputView.setBuffer(smallestIteratorKey, this.keyGroupPrefixBytes, smallestIteratorKey.length - this.keyGroupPrefixBytes);
            Object smallestIteratorKeyValue = CompositeKeySerializationUtils.readKey(this.keySerializer, (DataInputDeserializer)this.byteArrayDataInputView, (boolean)this.ambiguousKeyPossibles.get(smallestIteratorKeyIndex));
            if (AbstractRocksStateKeysIterator.isMatchingNameSpace(smallestIteratorKey, this.byteArrayDataInputView.getPosition(), this.namespaceBytes) && !Objects.equals(this.previousKey, smallestIteratorKeyValue)) {
                return (K)smallestIteratorKeyValue;
            }
        }
        return null;
    }

    @Override
    public K next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("Failed to access states [" + String.join((CharSequence)",", this.states) + "]");
        }
        K tmpKey = this.nextKey;
        this.nextKey = null;
        return tmpKey;
    }

    @Override
    public void close() {
        for (RocksIteratorWrapper iterator : this.iterators) {
            iterator.close();
        }
    }
}

