/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.contrib.streaming.state;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import javax.annotation.Nullable;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.contrib.streaming.state.PredefinedOptions;
import org.apache.flink.contrib.streaming.state.RocksDBConfigurableOptions;
import org.apache.flink.contrib.streaming.state.RocksDBKeyedStateBackendBuilder;
import org.apache.flink.contrib.streaming.state.RocksDBNativeMetricOptions;
import org.apache.flink.contrib.streaming.state.RocksDBOptionsFactory;
import org.apache.flink.contrib.streaming.state.RocksDBSharedResources;
import org.apache.flink.runtime.memory.OpaqueMemoryResource;
import org.apache.flink.util.FileUtils;
import org.apache.flink.util.IOUtils;
import org.apache.flink.util.Preconditions;
import org.rocksdb.BlockBasedTableConfig;
import org.rocksdb.BloomFilter;
import org.rocksdb.Cache;
import org.rocksdb.ColumnFamilyOptions;
import org.rocksdb.DBOptions;
import org.rocksdb.Filter;
import org.rocksdb.IndexType;
import org.rocksdb.PlainTableConfig;
import org.rocksdb.ReadOptions;
import org.rocksdb.Statistics;
import org.rocksdb.TableFormatConfig;
import org.rocksdb.WriteOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RocksDBResourceContainer
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(RocksDBResourceContainer.class);
    private static final String ROCKSDB_RELOCATE_LOG_SUFFIX = "_LOG";
    private static final int INSTANCE_PATH_LENGTH_LIMIT = 255 - "_LOG".length();
    @Nullable
    private final File instanceRocksDBPath;
    private final ReadableConfig configuration;
    private final PredefinedOptions predefinedOptions;
    @Nullable
    private final RocksDBOptionsFactory optionsFactory;
    @Nullable
    private final OpaqueMemoryResource<RocksDBSharedResources> sharedResources;
    private final boolean enableStatistics;
    private final ArrayList<AutoCloseable> handlesToClose;
    @Nullable
    private Path relocatedDbLogBaseDir;

    @VisibleForTesting
    public RocksDBResourceContainer() {
        this((ReadableConfig)new Configuration(), PredefinedOptions.DEFAULT, null, null, null, false);
    }

    @VisibleForTesting
    public RocksDBResourceContainer(PredefinedOptions predefinedOptions, @Nullable RocksDBOptionsFactory optionsFactory) {
        this((ReadableConfig)new Configuration(), predefinedOptions, optionsFactory, null, null, false);
    }

    @VisibleForTesting
    public RocksDBResourceContainer(PredefinedOptions predefinedOptions, @Nullable RocksDBOptionsFactory optionsFactory, @Nullable OpaqueMemoryResource<RocksDBSharedResources> sharedResources) {
        this((ReadableConfig)new Configuration(), predefinedOptions, optionsFactory, sharedResources, null, false);
    }

    public RocksDBResourceContainer(ReadableConfig configuration, PredefinedOptions predefinedOptions, @Nullable RocksDBOptionsFactory optionsFactory, @Nullable OpaqueMemoryResource<RocksDBSharedResources> sharedResources, @Nullable File instanceBasePath, boolean enableStatistics) {
        this.configuration = configuration;
        this.predefinedOptions = (PredefinedOptions)((Object)Preconditions.checkNotNull((Object)((Object)predefinedOptions)));
        this.optionsFactory = optionsFactory;
        this.sharedResources = sharedResources;
        this.instanceRocksDBPath = instanceBasePath != null ? RocksDBKeyedStateBackendBuilder.getInstanceRocksDBPath(instanceBasePath) : null;
        this.enableStatistics = enableStatistics;
        this.handlesToClose = new ArrayList();
    }

    public DBOptions getDbOptions() {
        DBOptions opt = this.createBaseCommonDBOptions();
        this.handlesToClose.add((AutoCloseable)opt);
        this.setDBOptionsFromConfigurableOptions(opt);
        if (this.optionsFactory != null) {
            opt = this.optionsFactory.createDBOptions(opt, this.handlesToClose);
        }
        opt = opt.setCreateIfMissing(true).setAvoidFlushDuringShutdown(true);
        if (this.sharedResources != null) {
            opt.setWriteBufferManager(((RocksDBSharedResources)this.sharedResources.getResourceHandle()).getWriteBufferManager());
        }
        if (this.enableStatistics) {
            Statistics statistics = new Statistics();
            opt.setStatistics(statistics);
            this.handlesToClose.add((AutoCloseable)statistics);
        }
        return opt;
    }

    public Long getWriteBufferManagerCapacity() {
        if (this.sharedResources == null) {
            return null;
        }
        return ((RocksDBSharedResources)this.sharedResources.getResourceHandle()).getWriteBufferManagerCapacity();
    }

    public ColumnFamilyOptions getColumnOptions() {
        ColumnFamilyOptions opt = this.createBaseCommonColumnOptions();
        this.handlesToClose.add((AutoCloseable)opt);
        this.setColumnFamilyOptionsFromConfigurableOptions(opt, this.handlesToClose);
        if (this.optionsFactory != null) {
            opt = this.optionsFactory.createColumnOptions(opt, this.handlesToClose);
        }
        if (this.sharedResources != null) {
            BlockBasedTableConfig blockBasedTableConfig;
            RocksDBSharedResources rocksResources = (RocksDBSharedResources)this.sharedResources.getResourceHandle();
            Cache blockCache = rocksResources.getCache();
            TableFormatConfig tableFormatConfig = opt.tableFormatConfig();
            if (tableFormatConfig == null) {
                blockBasedTableConfig = new BlockBasedTableConfig();
            } else {
                Preconditions.checkArgument((boolean)(tableFormatConfig instanceof BlockBasedTableConfig), (Object)"We currently only support BlockBasedTableConfig When bounding total memory.");
                blockBasedTableConfig = (BlockBasedTableConfig)tableFormatConfig;
            }
            if (rocksResources.isUsingPartitionedIndexFilters() && this.overwriteFilterIfExist(blockBasedTableConfig)) {
                blockBasedTableConfig.setIndexType(IndexType.kTwoLevelIndexSearch);
                blockBasedTableConfig.setPartitionFilters(true);
                blockBasedTableConfig.setPinTopLevelIndexAndFilter(true);
            }
            blockBasedTableConfig.setBlockCache(blockCache);
            blockBasedTableConfig.setCacheIndexAndFilterBlocks(true);
            blockBasedTableConfig.setCacheIndexAndFilterBlocksWithHighPriority(true);
            blockBasedTableConfig.setPinL0FilterAndIndexBlocksInCache(true);
            opt.setTableFormatConfig((TableFormatConfig)blockBasedTableConfig);
        }
        return opt;
    }

    public WriteOptions getWriteOptions() {
        WriteOptions opt = new WriteOptions().setDisableWAL(true);
        this.handlesToClose.add((AutoCloseable)opt);
        if (this.optionsFactory != null) {
            opt = this.optionsFactory.createWriteOptions(opt, this.handlesToClose);
        }
        return opt;
    }

    public ReadOptions getReadOptions() {
        ReadOptions opt = new ReadOptions();
        this.handlesToClose.add((AutoCloseable)opt);
        if (this.optionsFactory != null) {
            opt = this.optionsFactory.createReadOptions(opt, this.handlesToClose);
        }
        return opt;
    }

    RocksDBNativeMetricOptions getMemoryWatcherOptions(RocksDBNativeMetricOptions defaultMetricOptions) {
        return this.optionsFactory == null ? defaultMetricOptions : this.optionsFactory.createNativeMetricsOptions(defaultMetricOptions);
    }

    PredefinedOptions getPredefinedOptions() {
        return this.predefinedOptions;
    }

    @Nullable
    RocksDBOptionsFactory getOptionsFactory() {
        return this.optionsFactory;
    }

    @Override
    public void close() throws Exception {
        this.handlesToClose.forEach(IOUtils::closeQuietly);
        this.handlesToClose.clear();
        if (this.sharedResources != null) {
            this.sharedResources.close();
        }
        this.cleanRelocatedDbLogs();
    }

    private boolean overwriteFilterIfExist(BlockBasedTableConfig blockBasedTableConfig) {
        if (blockBasedTableConfig.filterPolicy() != null) {
            BloomFilter newFilter = new BloomFilter(10.0, false);
            LOG.info("Existing filter has been overwritten to full filters since partitioned index filters is enabled.");
            blockBasedTableConfig.setFilterPolicy((Filter)newFilter);
            this.handlesToClose.add((AutoCloseable)newFilter);
        }
        return true;
    }

    DBOptions createBaseCommonDBOptions() {
        return new DBOptions().setUseFsync(false).setStatsDumpPeriodSec(0);
    }

    ColumnFamilyOptions createBaseCommonColumnOptions() {
        return new ColumnFamilyOptions();
    }

    @Nullable
    private <T> T internalGetOption(ConfigOption<T> option) {
        return (T)this.configuration.getOptional(option).orElseGet(() -> this.predefinedOptions.getValue(option));
    }

    private DBOptions setDBOptionsFromConfigurableOptions(DBOptions currentOptions) {
        currentOptions.setMaxBackgroundJobs(this.internalGetOption(RocksDBConfigurableOptions.MAX_BACKGROUND_THREADS).intValue());
        currentOptions.setMaxOpenFiles(this.internalGetOption(RocksDBConfigurableOptions.MAX_OPEN_FILES).intValue());
        currentOptions.setInfoLogLevel(this.internalGetOption(RocksDBConfigurableOptions.LOG_LEVEL));
        String logDir = this.internalGetOption(RocksDBConfigurableOptions.LOG_DIR);
        if (logDir == null || logDir.isEmpty()) {
            if (this.instanceRocksDBPath == null || this.instanceRocksDBPath.getAbsolutePath().length() <= INSTANCE_PATH_LENGTH_LIMIT) {
                this.relocateDefaultDbLogDir(currentOptions);
            } else {
                LOG.warn("RocksDB instance path length exceeds limit : {}, disable log relocate.", (Object)this.instanceRocksDBPath);
            }
        } else {
            currentOptions.setDbLogDir(logDir);
        }
        currentOptions.setMaxLogFileSize(this.internalGetOption(RocksDBConfigurableOptions.LOG_MAX_FILE_SIZE).getBytes());
        currentOptions.setKeepLogFileNum((long)this.internalGetOption(RocksDBConfigurableOptions.LOG_FILE_NUM).intValue());
        return currentOptions;
    }

    private ColumnFamilyOptions setColumnFamilyOptionsFromConfigurableOptions(ColumnFamilyOptions currentOptions, Collection<AutoCloseable> handlesToClose) {
        BlockBasedTableConfig blockBasedTableConfig;
        currentOptions.setCompactionStyle(this.internalGetOption(RocksDBConfigurableOptions.COMPACTION_STYLE));
        currentOptions.setCompressionPerLevel(this.internalGetOption(RocksDBConfigurableOptions.COMPRESSION_PER_LEVEL));
        currentOptions.setLevelCompactionDynamicLevelBytes(this.internalGetOption(RocksDBConfigurableOptions.USE_DYNAMIC_LEVEL_SIZE).booleanValue());
        currentOptions.setTargetFileSizeBase(this.internalGetOption(RocksDBConfigurableOptions.TARGET_FILE_SIZE_BASE).getBytes());
        currentOptions.setMaxBytesForLevelBase(this.internalGetOption(RocksDBConfigurableOptions.MAX_SIZE_LEVEL_BASE).getBytes());
        currentOptions.setWriteBufferSize(this.internalGetOption(RocksDBConfigurableOptions.WRITE_BUFFER_SIZE).getBytes());
        currentOptions.setMaxWriteBufferNumber(this.internalGetOption(RocksDBConfigurableOptions.MAX_WRITE_BUFFER_NUMBER).intValue());
        currentOptions.setMinWriteBufferNumberToMerge(this.internalGetOption(RocksDBConfigurableOptions.MIN_WRITE_BUFFER_NUMBER_TO_MERGE).intValue());
        TableFormatConfig tableFormatConfig = currentOptions.tableFormatConfig();
        if (tableFormatConfig == null) {
            blockBasedTableConfig = new BlockBasedTableConfig();
        } else {
            if (tableFormatConfig instanceof PlainTableConfig) {
                return currentOptions;
            }
            blockBasedTableConfig = (BlockBasedTableConfig)tableFormatConfig;
        }
        blockBasedTableConfig.setBlockSize(this.internalGetOption(RocksDBConfigurableOptions.BLOCK_SIZE).getBytes());
        blockBasedTableConfig.setMetadataBlockSize(this.internalGetOption(RocksDBConfigurableOptions.METADATA_BLOCK_SIZE).getBytes());
        blockBasedTableConfig.setBlockCacheSize(this.internalGetOption(RocksDBConfigurableOptions.BLOCK_CACHE_SIZE).getBytes());
        if (this.internalGetOption(RocksDBConfigurableOptions.USE_BLOOM_FILTER).booleanValue()) {
            double bitsPerKey = this.internalGetOption(RocksDBConfigurableOptions.BLOOM_FILTER_BITS_PER_KEY);
            boolean blockBasedMode = this.internalGetOption(RocksDBConfigurableOptions.BLOOM_FILTER_BLOCK_BASED_MODE);
            BloomFilter bloomFilter = new BloomFilter(bitsPerKey, blockBasedMode);
            handlesToClose.add((AutoCloseable)bloomFilter);
            blockBasedTableConfig.setFilterPolicy((Filter)bloomFilter);
        }
        return currentOptions.setTableFormatConfig((TableFormatConfig)blockBasedTableConfig);
    }

    private void relocateDefaultDbLogDir(DBOptions dbOptions) {
        File logFile;
        String logFilePath = System.getProperty("log.file");
        if (logFilePath != null && (logFile = this.resolveFileLocation(logFilePath)) != null && this.resolveFileLocation(logFile.getParent()) != null) {
            String relocatedDbLogDir = logFile.getParent();
            this.relocatedDbLogBaseDir = new File(relocatedDbLogDir).toPath();
            dbOptions.setDbLogDir(relocatedDbLogDir);
        }
    }

    private File resolveFileLocation(String logFilePath) {
        File logFile = new File(logFilePath);
        return logFile.exists() && logFile.canRead() ? logFile : null;
    }

    private void cleanRelocatedDbLogs() {
        if (this.instanceRocksDBPath != null && this.relocatedDbLogBaseDir != null) {
            LOG.info("Cleaning up relocated RocksDB logs: {}.", (Object)this.relocatedDbLogBaseDir);
            String relocatedDbLogPrefix = this.resolveRelocatedDbLogPrefix(this.instanceRocksDBPath.getAbsolutePath());
            try {
                Arrays.stream(FileUtils.listDirectory((Path)this.relocatedDbLogBaseDir)).filter(path -> !Files.isDirectory(path, new LinkOption[0]) && path.toFile().getName().startsWith(relocatedDbLogPrefix)).forEach(IOUtils::deleteFileQuietly);
            }
            catch (IOException e) {
                LOG.warn("Could not list relocated RocksDB log directory: {}", (Object)this.relocatedDbLogBaseDir);
            }
        }
    }

    private String resolveRelocatedDbLogPrefix(String instanceRocksDBAbsolutePath) {
        if (!instanceRocksDBAbsolutePath.isEmpty() && !instanceRocksDBAbsolutePath.matches("^[a-zA-Z0-9\\-._].*")) {
            instanceRocksDBAbsolutePath = instanceRocksDBAbsolutePath.substring(1);
        }
        return instanceRocksDBAbsolutePath.replaceAll("[^a-zA-Z0-9\\-._]", "_") + ROCKSDB_RELOCATE_LOG_SUFFIX;
    }
}

