/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.heap;

import java.io.IOException;
import java.io.InputStream;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataInputViewStreamWrapper;
import org.apache.flink.core.memory.DataOutputSerializer;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemorySegmentInputStreamWithPos;

class SkipListValueSerializer<S> {
    private final TypeSerializer<S> stateSerializer;
    private final DataOutputSerializer dos;

    SkipListValueSerializer(TypeSerializer<S> stateSerializer) {
        this.stateSerializer = stateSerializer;
        this.dos = new DataOutputSerializer(16);
    }

    byte[] serialize(S state) {
        try {
            this.stateSerializer.serialize(state, (DataOutputView)this.dos);
        }
        catch (IOException e) {
            throw new RuntimeException("serialize key and namespace failed", e);
        }
        byte[] ret = this.dos.getCopyOfBuffer();
        this.dos.clear();
        return ret;
    }

    S deserializeState(MemorySegment memorySegment, int offset, int len) {
        MemorySegmentInputStreamWithPos src = new MemorySegmentInputStreamWithPos(memorySegment, offset, len);
        DataInputViewStreamWrapper in = new DataInputViewStreamWrapper((InputStream)src);
        try {
            return (S)this.stateSerializer.deserialize((DataInputView)in);
        }
        catch (IOException e) {
            throw new RuntimeException("deserialize state failed", e);
        }
    }
}

