/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.heap;

import javax.annotation.Nonnull;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.runtime.state.heap.LevelIndexHeader;
import org.apache.flink.runtime.state.heap.NodeStatus;
import org.apache.flink.runtime.state.heap.SkipListKeyComparator;
import org.apache.flink.runtime.state.heap.space.Allocator;
import org.apache.flink.runtime.state.heap.space.Chunk;
import org.apache.flink.runtime.state.heap.space.SpaceUtils;
import org.apache.flink.util.Preconditions;

public class SkipListUtils {
    static final long NIL_NODE = -1L;
    static final long HEAD_NODE = -2L;
    static final long NIL_VALUE_POINTER = -1L;
    static final int MAX_LEVEL = 255;
    static final int DEFAULT_LEVEL = 32;
    static final int BYTE_MASK = 255;
    static final int KEY_META_OFFSET = 0;
    static final int KEY_LEN_OFFSET = 4;
    static final int VALUE_POINTER_OFFSET = 8;
    static final int NEXT_KEY_POINTER_OFFSET = 16;
    static final int LEVEL_INDEX_OFFSET = 24;
    private static final int[] INDEX_NEXT_OFFSET_BY_LEVEL_ARRAY;
    private static final int[] KEY_META_LEN_BY_LEVEL_ARRAY;
    static final int VALUE_META_OFFSET = 0;
    static final int VALUE_VERSION_OFFSET = 0;
    static final int KEY_POINTER_OFFSET = 4;
    static final int NEXT_VALUE_POINTER_OFFSET = 12;
    static final int VALUE_LEN_OFFSET = 20;
    static final int VALUE_DATA_OFFSET = 24;

    public static int getLevel(MemorySegment memorySegment, int offset) {
        return memorySegment.getInt(offset + 0) & 0xFF;
    }

    public static NodeStatus getNodeStatus(MemorySegment memorySegment, int offset) {
        byte status = (byte)(memorySegment.getInt(offset + 0) >>> 8 & 0xFF);
        return NodeStatus.valueOf(status);
    }

    public static void putLevelAndNodeStatus(MemorySegment memorySegment, int offset, int level, NodeStatus status) {
        int data = (status.getValue() & 0xFF) << 8 | level;
        memorySegment.putInt(offset + 0, data);
    }

    public static int getKeyLen(MemorySegment memorySegment, int offset) {
        return memorySegment.getInt(offset + 4);
    }

    public static void putKeyLen(MemorySegment memorySegment, int offset, int keyLen) {
        memorySegment.putInt(offset + 4, keyLen);
    }

    public static long getValuePointer(MemorySegment memorySegment, int offset) {
        return memorySegment.getLong(offset + 8);
    }

    public static void putValuePointer(MemorySegment memorySegment, int offset, long valuePointer) {
        memorySegment.putLong(offset + 8, valuePointer);
    }

    public static long getNextKeyPointer(MemorySegment memorySegment, int offset) {
        return memorySegment.getLong(offset + 16);
    }

    public static void putNextKeyPointer(MemorySegment memorySegment, int offset, long nextKeyPointer) {
        memorySegment.putLong(offset + 16, nextKeyPointer);
    }

    public static long getNextIndexNode(MemorySegment memorySegment, int offset, int level) {
        return memorySegment.getLong(offset + INDEX_NEXT_OFFSET_BY_LEVEL_ARRAY[level]);
    }

    public static void putNextIndexNode(MemorySegment memorySegment, int offset, int level, long nextKeyPointer) {
        memorySegment.putLong(offset + INDEX_NEXT_OFFSET_BY_LEVEL_ARRAY[level], nextKeyPointer);
    }

    public static long getPrevIndexNode(MemorySegment memorySegment, int offset, int totalLevel, int level) {
        int of = SkipListUtils.getIndexOffset(offset, totalLevel, level);
        return memorySegment.getLong(of);
    }

    private static int getIndexOffset(int offset, int totalLevel, int level) {
        return offset + INDEX_NEXT_OFFSET_BY_LEVEL_ARRAY[totalLevel] + level * 8;
    }

    public static void putPrevIndexNode(MemorySegment memorySegment, int offset, int totalLevel, int level, long prevKeyPointer) {
        int of = SkipListUtils.getIndexOffset(offset, totalLevel, level);
        memorySegment.putLong(of, prevKeyPointer);
    }

    public static int getKeyMetaLen(int level) {
        Preconditions.checkArgument((level >= 0 && level < KEY_META_LEN_BY_LEVEL_ARRAY.length ? 1 : 0) != 0, (Object)("level " + level + " out of range [0, " + KEY_META_LEN_BY_LEVEL_ARRAY.length + ")"));
        return KEY_META_LEN_BY_LEVEL_ARRAY[level];
    }

    public static int getKeyDataOffset(int level) {
        return SkipListUtils.getKeyMetaLen(level);
    }

    public static void putKeyData(MemorySegment segment, int offset, MemorySegment keySegment, int keyOffset, int keyLen, int level) {
        keySegment.copyTo(keyOffset, segment, offset + SkipListUtils.getKeyDataOffset(level), keyLen);
    }

    public static int getValueVersion(MemorySegment memorySegment, int offset) {
        return memorySegment.getInt(offset + 0);
    }

    public static void putValueVersion(MemorySegment memorySegment, int offset, int version) {
        memorySegment.putInt(offset + 0, version);
    }

    public static long getKeyPointer(MemorySegment memorySegment, int offset) {
        return memorySegment.getLong(offset + 4);
    }

    public static void putKeyPointer(MemorySegment memorySegment, int offset, long keyPointer) {
        memorySegment.putLong(offset + 4, keyPointer);
    }

    public static long getNextValuePointer(MemorySegment memorySegment, int offset) {
        return memorySegment.getLong(offset + 12);
    }

    public static void putNextValuePointer(MemorySegment memorySegment, int offset, long nextValuePointer) {
        memorySegment.putLong(offset + 12, nextValuePointer);
    }

    public static int getValueLen(MemorySegment memorySegment, int offset) {
        return memorySegment.getInt(offset + 20);
    }

    public static void putValueLen(MemorySegment memorySegment, int offset, int valueLen) {
        memorySegment.putInt(offset + 20, valueLen);
    }

    public static int getValueMetaLen() {
        return 24;
    }

    public static void putValueData(MemorySegment memorySegment, int offset, byte[] value) {
        MemorySegment valueSegment = MemorySegmentFactory.wrap((byte[])value);
        valueSegment.copyTo(0, memorySegment, offset + SkipListUtils.getValueMetaLen(), value.length);
    }

    static void helpSetNextNode(long node, long nextNode, int level, LevelIndexHeader levelIndexHeader, Allocator spaceAllocator) {
        if (node == -2L) {
            levelIndexHeader.updateNextNode(level, nextNode);
            return;
        }
        Chunk chunk = spaceAllocator.getChunkById(SpaceUtils.getChunkIdByAddress(node));
        int offsetInChunk = SpaceUtils.getChunkOffsetByAddress(node);
        MemorySegment segment = chunk.getMemorySegment(offsetInChunk);
        int offsetInByteBuffer = chunk.getOffsetInSegment(offsetInChunk);
        if (level == 0) {
            SkipListUtils.putNextKeyPointer(segment, offsetInByteBuffer, nextNode);
        } else {
            SkipListUtils.putNextIndexNode(segment, offsetInByteBuffer, level, nextNode);
        }
    }

    static long helpGetNextNode(long node, int level, LevelIndexHeader levelIndexHeader, Allocator spaceAllocator) {
        if (node == -2L) {
            return levelIndexHeader.getNextNode(level);
        }
        Chunk chunk = spaceAllocator.getChunkById(SpaceUtils.getChunkIdByAddress(node));
        int offsetInChunk = SpaceUtils.getChunkOffsetByAddress(node);
        MemorySegment segment = chunk.getMemorySegment(offsetInChunk);
        int offsetInByteBuffer = chunk.getOffsetInSegment(offsetInChunk);
        return level == 0 ? SkipListUtils.getNextKeyPointer(segment, offsetInByteBuffer) : SkipListUtils.getNextIndexNode(segment, offsetInByteBuffer, level);
    }

    static void helpSetPrevNode(long node, long prevNode, int level, Allocator spaceAllocator) {
        Preconditions.checkArgument((level > 0 ? 1 : 0) != 0, (Object)"only index level have previous node");
        if (node == -2L || node == -1L) {
            return;
        }
        Chunk chunk = spaceAllocator.getChunkById(SpaceUtils.getChunkIdByAddress(node));
        int offsetInChunk = SpaceUtils.getChunkOffsetByAddress(node);
        MemorySegment segment = chunk.getMemorySegment(offsetInChunk);
        int offsetInByteBuffer = chunk.getOffsetInSegment(offsetInChunk);
        int topLevel = SkipListUtils.getLevel(segment, offsetInByteBuffer);
        SkipListUtils.putPrevIndexNode(segment, offsetInByteBuffer, topLevel, level, prevNode);
    }

    static void helpSetPrevAndNextNode(long node, long prevNode, long nextNode, int level, Allocator spaceAllocator) {
        Preconditions.checkArgument((node != -2L ? 1 : 0) != 0, (Object)"head node does not have previous node");
        Preconditions.checkArgument((level > 0 ? 1 : 0) != 0, (Object)"only index level have previous node");
        Chunk chunk = spaceAllocator.getChunkById(SpaceUtils.getChunkIdByAddress(node));
        int offsetInChunk = SpaceUtils.getChunkOffsetByAddress(node);
        MemorySegment segment = chunk.getMemorySegment(offsetInChunk);
        int offsetInByteBuffer = chunk.getOffsetInSegment(offsetInChunk);
        int topLevel = SkipListUtils.getLevel(segment, offsetInByteBuffer);
        SkipListUtils.putNextIndexNode(segment, offsetInByteBuffer, level, nextNode);
        SkipListUtils.putPrevIndexNode(segment, offsetInByteBuffer, topLevel, level, prevNode);
    }

    static boolean isNodeRemoved(long node, Allocator spaceAllocator) {
        int offsetInByteBuffer;
        int offsetInChunk;
        if (node == -1L) {
            return false;
        }
        Chunk chunk = spaceAllocator.getChunkById(SpaceUtils.getChunkIdByAddress(node));
        MemorySegment segment = chunk.getMemorySegment(offsetInChunk = SpaceUtils.getChunkOffsetByAddress(node));
        return SkipListUtils.getNodeStatus(segment, offsetInByteBuffer = chunk.getOffsetInSegment(offsetInChunk)) == NodeStatus.REMOVE;
    }

    static int compareSegmentAndNode(MemorySegment keySegment, int keyOffset, long targetNode, @Nonnull Allocator spaceAllocator) {
        Chunk chunk = spaceAllocator.getChunkById(SpaceUtils.getChunkIdByAddress(targetNode));
        int offsetInChunk = SpaceUtils.getChunkOffsetByAddress(targetNode);
        MemorySegment targetKeySegment = chunk.getMemorySegment(offsetInChunk);
        int offsetInByteBuffer = chunk.getOffsetInSegment(offsetInChunk);
        int level = SkipListUtils.getLevel(targetKeySegment, offsetInByteBuffer);
        int targetKeyOffset = offsetInByteBuffer + SkipListUtils.getKeyDataOffset(level);
        return SkipListKeyComparator.compareTo(keySegment, keyOffset, targetKeySegment, targetKeyOffset);
    }

    static long findPredecessor(long node, int level, LevelIndexHeader levelIndexHeader, @Nonnull Allocator spaceAllocator) {
        Chunk chunk = spaceAllocator.getChunkById(SpaceUtils.getChunkIdByAddress(node));
        int offsetInChunk = SpaceUtils.getChunkOffsetByAddress(node);
        MemorySegment keySegment = chunk.getMemorySegment(offsetInChunk);
        int offsetInByteBuffer = chunk.getOffsetInSegment(offsetInChunk);
        int keyLevel = SkipListUtils.getLevel(keySegment, offsetInByteBuffer);
        int keyOffset = offsetInByteBuffer + SkipListUtils.getKeyDataOffset(keyLevel);
        return SkipListUtils.findPredecessor(keySegment, keyOffset, level, levelIndexHeader, spaceAllocator);
    }

    static long findPredecessor(MemorySegment keySegment, int keyOffset, int level, @Nonnull LevelIndexHeader levelIndexHeader, Allocator spaceAllocator) {
        int currentLevel = levelIndexHeader.getLevel();
        long currentNode = -2L;
        long nextNode = levelIndexHeader.getNextNode(currentLevel);
        while (true) {
            int c;
            if (nextNode != -1L && (c = SkipListUtils.compareSegmentAndNode(keySegment, keyOffset, nextNode, spaceAllocator)) > 0) {
                currentNode = nextNode;
                nextNode = SkipListUtils.helpGetNextNode(currentNode, currentLevel, levelIndexHeader, spaceAllocator);
                continue;
            }
            if (currentLevel <= level) {
                return currentNode;
            }
            nextNode = SkipListUtils.helpGetNextNode(currentNode, --currentLevel, levelIndexHeader, spaceAllocator);
        }
    }

    static long helpGetNextValuePointer(long valuePointer, Allocator spaceAllocator) {
        Chunk chunk = spaceAllocator.getChunkById(SpaceUtils.getChunkIdByAddress(valuePointer));
        int offsetInChunk = SpaceUtils.getChunkOffsetByAddress(valuePointer);
        MemorySegment segment = chunk.getMemorySegment(offsetInChunk);
        int offsetInByteBuffer = chunk.getOffsetInSegment(offsetInChunk);
        return SkipListUtils.getNextValuePointer(segment, offsetInByteBuffer);
    }

    static void helpSetNextValuePointer(long valuePointer, long nextValuePointer, Allocator spaceAllocator) {
        Chunk chunk = spaceAllocator.getChunkById(SpaceUtils.getChunkIdByAddress(valuePointer));
        int offsetInChunk = SpaceUtils.getChunkOffsetByAddress(valuePointer);
        MemorySegment segment = chunk.getMemorySegment(offsetInChunk);
        int offsetInByteBuffer = chunk.getOffsetInSegment(offsetInChunk);
        SkipListUtils.putNextValuePointer(segment, offsetInByteBuffer, nextValuePointer);
    }

    static void buildLevelIndex(long node, int level, MemorySegment keySegment, int keyOffset, LevelIndexHeader levelIndexHeader, Allocator spaceAllocator) {
        int currLevel = level;
        long prevNode = SkipListUtils.findPredecessor(keySegment, keyOffset, currLevel, levelIndexHeader, spaceAllocator);
        long currentNode = SkipListUtils.helpGetNextNode(prevNode, currLevel, levelIndexHeader, spaceAllocator);
        while (true) {
            int c;
            if (currentNode != -1L && (c = SkipListUtils.compareSegmentAndNode(keySegment, keyOffset, currentNode, spaceAllocator)) > 0) {
                prevNode = currentNode;
                currentNode = SkipListUtils.helpGetNextNode(currentNode, currLevel, levelIndexHeader, spaceAllocator);
                continue;
            }
            SkipListUtils.helpSetPrevAndNextNode(node, prevNode, currentNode, currLevel, spaceAllocator);
            SkipListUtils.helpSetNextNode(prevNode, node, currLevel, levelIndexHeader, spaceAllocator);
            SkipListUtils.helpSetPrevNode(currentNode, node, currLevel, spaceAllocator);
            if (--currLevel == 0) break;
            currentNode = SkipListUtils.helpGetNextNode(prevNode, currLevel, levelIndexHeader, spaceAllocator);
        }
    }

    static void removeLevelIndex(long node, Allocator spaceAllocator, LevelIndexHeader levelIndexHeader) {
        Chunk chunk = spaceAllocator.getChunkById(SpaceUtils.getChunkIdByAddress(node));
        int offsetInChunk = SpaceUtils.getChunkOffsetByAddress(node);
        MemorySegment segment = chunk.getMemorySegment(offsetInChunk);
        int offsetInByteBuffer = chunk.getOffsetInSegment(offsetInChunk);
        int level = SkipListUtils.getLevel(segment, offsetInByteBuffer);
        for (int i = 1; i <= level; ++i) {
            long prevNode = SkipListUtils.getPrevIndexNode(segment, offsetInByteBuffer, level, i);
            long nextNode = SkipListUtils.getNextIndexNode(segment, offsetInByteBuffer, i);
            SkipListUtils.helpSetNextNode(prevNode, nextNode, i, levelIndexHeader, spaceAllocator);
            SkipListUtils.helpSetPrevNode(nextNode, prevNode, i, spaceAllocator);
        }
    }

    static void removeAllValues(long valuePointer, Allocator spaceAllocator) {
        while (valuePointer != -1L) {
            long nextValuePointer = SkipListUtils.helpGetNextValuePointer(valuePointer, spaceAllocator);
            spaceAllocator.free(valuePointer);
            valuePointer = nextValuePointer;
        }
    }

    static long helpGetValuePointer(long node, Allocator spaceAllocator) {
        Chunk chunk = spaceAllocator.getChunkById(SpaceUtils.getChunkIdByAddress(node));
        int offsetInChunk = SpaceUtils.getChunkOffsetByAddress(node);
        MemorySegment segment = chunk.getMemorySegment(offsetInChunk);
        int offsetInByteBuffer = chunk.getOffsetInSegment(offsetInChunk);
        return SkipListUtils.getValuePointer(segment, offsetInByteBuffer);
    }

    static int helpGetValueVersion(long valuePointer, Allocator spaceAllocator) {
        Chunk chunk = spaceAllocator.getChunkById(SpaceUtils.getChunkIdByAddress(valuePointer));
        int offsetInChunk = SpaceUtils.getChunkOffsetByAddress(valuePointer);
        MemorySegment segment = chunk.getMemorySegment(offsetInChunk);
        int offsetInByteBuffer = chunk.getOffsetInSegment(offsetInChunk);
        return SkipListUtils.getValueVersion(segment, offsetInByteBuffer);
    }

    static int helpGetValueLen(long valuePointer, Allocator spaceAllocator) {
        Chunk chunk = spaceAllocator.getChunkById(SpaceUtils.getChunkIdByAddress(valuePointer));
        int offsetInChunk = SpaceUtils.getChunkOffsetByAddress(valuePointer);
        MemorySegment segment = chunk.getMemorySegment(offsetInChunk);
        int offsetInByteBuffer = chunk.getOffsetInSegment(offsetInChunk);
        return SkipListUtils.getValueLen(segment, offsetInByteBuffer);
    }

    static int helpGetNodeLatestVersion(long node, Allocator spaceAllocator) {
        Chunk chunk = spaceAllocator.getChunkById(SpaceUtils.getChunkIdByAddress(node));
        int offsetInChunk = SpaceUtils.getChunkOffsetByAddress(node);
        MemorySegment segment = chunk.getMemorySegment(offsetInChunk);
        int offsetInByteBuffer = chunk.getOffsetInSegment(offsetInChunk);
        long valuePointer = SkipListUtils.getValuePointer(segment, offsetInByteBuffer);
        return SkipListUtils.helpGetValueVersion(valuePointer, spaceAllocator);
    }

    static {
        int i;
        INDEX_NEXT_OFFSET_BY_LEVEL_ARRAY = new int[256];
        KEY_META_LEN_BY_LEVEL_ARRAY = new int[256];
        for (i = 1; i < INDEX_NEXT_OFFSET_BY_LEVEL_ARRAY.length; ++i) {
            SkipListUtils.INDEX_NEXT_OFFSET_BY_LEVEL_ARRAY[i] = 24 + (i - 1) * 8;
        }
        for (i = 0; i < KEY_META_LEN_BY_LEVEL_ARRAY.length; ++i) {
            SkipListUtils.KEY_META_LEN_BY_LEVEL_ARRAY[i] = 24 + 2 * i * 8;
        }
    }
}

