/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.heap;

import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.runtime.state.heap.LevelIndexHeader;
import org.apache.flink.util.Preconditions;

public class OnHeapLevelIndexHeader
implements LevelIndexHeader {
    private volatile long[] levelIndex;
    private volatile int topLevel;
    private volatile long nextNode;

    OnHeapLevelIndexHeader() {
        this(32);
    }

    private OnHeapLevelIndexHeader(int maxLevel) {
        Preconditions.checkArgument((maxLevel >= 1 && maxLevel <= 255 ? 1 : 0) != 0, (Object)("maxLevel(" + maxLevel + ") must be non-negative and no more than " + 255));
        this.topLevel = 1;
        this.nextNode = -1L;
        this.levelIndex = new long[maxLevel];
        this.initLevelIndex(this.levelIndex);
    }

    private void initLevelIndex(long[] levelIndex) {
        for (int i = 0; i < levelIndex.length; ++i) {
            levelIndex[i] = -1L;
        }
    }

    @Override
    public int getLevel() {
        return this.topLevel;
    }

    @Override
    public void updateLevel(int level) {
        Preconditions.checkArgument((level >= 0 && level <= 255 ? 1 : 0) != 0, (Object)("level(" + level + ") must be non-negative and no more than " + 255));
        Preconditions.checkArgument((level <= this.topLevel + 1 ? 1 : 0) != 0, (Object)("top level " + this.topLevel + " must be updated level by level, but new level is " + level));
        if (this.levelIndex.length < level) {
            long[] newLevelIndex = new long[this.levelIndex.length * 2];
            this.initLevelIndex(newLevelIndex);
            System.arraycopy(this.levelIndex, 0, newLevelIndex, 0, this.levelIndex.length);
            this.levelIndex = newLevelIndex;
        }
        if (this.topLevel < level) {
            this.topLevel = level;
        }
    }

    @Override
    public long getNextNode(int level) {
        Preconditions.checkArgument((level >= 0 && level <= this.topLevel ? 1 : 0) != 0, (Object)("invalid level " + level + " current top level is " + this.topLevel));
        if (level == 0) {
            return this.nextNode;
        }
        return this.levelIndex[level - 1];
    }

    @Override
    public void updateNextNode(int level, long node) {
        Preconditions.checkArgument((level >= 0 && level <= this.topLevel ? 1 : 0) != 0, (Object)("invalid level " + level + " current top level is " + this.topLevel));
        if (level == 0) {
            this.nextNode = node;
        } else {
            this.levelIndex[level - 1] = node;
        }
    }

    @VisibleForTesting
    long[] getLevelIndex() {
        return this.levelIndex;
    }
}

