/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.forst.fs.cache;

import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.state.forst.fs.cache.CacheLimitPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SizeBasedCacheLimitPolicy
implements CacheLimitPolicy {
    private static final Logger LOG = LoggerFactory.getLogger(SizeBasedCacheLimitPolicy.class);
    private final long capacity;
    private final long sstFileSize;
    private long usageSize;

    public SizeBasedCacheLimitPolicy(long capacity, long sstFileSize) {
        this.capacity = capacity;
        this.sstFileSize = sstFileSize;
        this.usageSize = 0L;
        LOG.info("Creating SizeBasedCacheLimitPolicy with capacity {}", (Object)capacity);
    }

    @Override
    public boolean directWriteInCache() {
        return this.isSafeToAdd(this.sstFileSize);
    }

    @Override
    public boolean isSafeToAdd(long toAddSize) {
        return toAddSize <= this.capacity;
    }

    @Override
    public boolean isOverflow(long toAddSize, boolean hasFile) {
        return this.usageSize + toAddSize > this.capacity;
    }

    @Override
    public void acquire(long toAddSize) {
        this.usageSize += toAddSize;
    }

    @Override
    public void release(long toReleaseSize) {
        this.usageSize -= Math.min(this.usageSize, toReleaseSize);
    }

    @Override
    public long usedBytes() {
        return this.usageSize;
    }

    @Override
    public void registerCustomizedMetrics(String prefix, MetricGroup metricGroup) {
    }

    public String toString() {
        return "SizeBasedCacheLimitPolicy{capacity=" + this.capacity + ", usageSize=" + this.usageSize + "}";
    }
}

