/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.forst.datatransfer;

import java.io.IOException;
import java.util.Objects;
import org.apache.flink.core.fs.CloseableRegistry;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.state.CheckpointStreamFactory;
import org.apache.flink.runtime.state.CheckpointedStateScope;
import org.apache.flink.runtime.state.IncrementalKeyedStateHandle;
import org.apache.flink.runtime.state.StreamStateHandle;
import org.apache.flink.runtime.state.memory.ByteStreamStateHandle;
import org.apache.flink.state.forst.datatransfer.CopyDataTransferStrategy;
import org.apache.flink.state.forst.fs.ForStFlinkFileSystem;
import org.apache.flink.state.forst.fs.filemapping.FileOwnership;
import org.apache.flink.state.forst.fs.filemapping.FileOwnershipDecider;
import org.apache.flink.state.forst.fs.filemapping.MappingEntry;
import org.apache.flink.state.forst.fs.filemapping.MappingEntrySource;
import org.apache.flink.util.Preconditions;

public class ReusableDataTransferStrategy
extends CopyDataTransferStrategy {
    ReusableDataTransferStrategy(FileSystem dbFileSystem) {
        super(dbFileSystem);
        Preconditions.checkArgument((boolean)(dbFileSystem instanceof ForStFlinkFileSystem), (Object)("Unexpected dbFileSystem type: " + String.valueOf(dbFileSystem.getClass()) + ", expected: " + String.valueOf(ForStFlinkFileSystem.class)));
    }

    private ForStFlinkFileSystem getForStFlinkFileSystem() {
        return (ForStFlinkFileSystem)this.dbFileSystem;
    }

    private IncrementalKeyedStateHandle.HandleAndLocalPath reuseFileToCheckpoint(Path dbFilePath, ForStFlinkFileSystem forStFs) throws IOException {
        LOG.trace("Reuse file to checkpoint: {}", (Object)dbFilePath);
        MappingEntry mappingEntry = Objects.requireNonNull(forStFs.getMappingEntry(dbFilePath));
        MappingEntrySource source = mappingEntry.getSource();
        StreamStateHandle stateHandle = source.toStateHandle();
        forStFs.giveUpOwnership(dbFilePath, stateHandle);
        return IncrementalKeyedStateHandle.HandleAndLocalPath.of((StreamStateHandle)stateHandle, (String)dbFilePath.getName());
    }

    @Override
    public IncrementalKeyedStateHandle.HandleAndLocalPath transferToCheckpoint(Path dbFilePath, long maxTransferBytes, CheckpointStreamFactory checkpointStreamFactory, CheckpointedStateScope stateScope, CloseableRegistry closeableRegistry, CloseableRegistry tmpResourcesRegistry) throws IOException {
        if (maxTransferBytes < 0L) {
            maxTransferBytes = Long.MAX_VALUE;
        }
        ForStFlinkFileSystem forStFs = this.getForStFlinkFileSystem();
        MappingEntry mappingEntry = forStFs.getMappingEntry(dbFilePath);
        Preconditions.checkNotNull((Object)((Object)mappingEntry));
        FileOwnership fileOwnership = mappingEntry.getFileOwnership();
        if (fileOwnership == FileOwnership.PRIVATE_OWNED_BY_DB) {
            LOG.trace("Do not reuse file to checkpoint because the file is privately owned by DB: {}", (Object)dbFilePath);
            return super.transferToCheckpoint(dbFilePath, maxTransferBytes, checkpointStreamFactory, stateScope, closeableRegistry, tmpResourcesRegistry);
        }
        return this.reuseFileToCheckpoint(dbFilePath, forStFs);
    }

    @Override
    public void transferFromCheckpoint(StreamStateHandle sourceHandle, Path targetPath, CloseableRegistry closeableRegistry) throws IOException {
        if (sourceHandle instanceof ByteStreamStateHandle) {
            LOG.trace("Not reusing file from checkpoint because it is stored in Memory: {}", (Object)targetPath);
            super.transferFromCheckpoint(sourceHandle, targetPath, closeableRegistry);
            return;
        }
        FileOwnership fileOwnership = FileOwnershipDecider.decideForRestoredFile(targetPath);
        if (fileOwnership == FileOwnership.PRIVATE_OWNED_BY_DB) {
            LOG.trace("Not reusing file from checkpoint because the file is privately owned by DB: {}", (Object)targetPath);
            super.transferFromCheckpoint(sourceHandle, targetPath, closeableRegistry);
            return;
        }
        this.reuseFileFromCheckpoint(sourceHandle, targetPath);
    }

    private void reuseFileFromCheckpoint(StreamStateHandle sourceHandle, Path targetPath) throws IOException {
        LOG.trace("Reuse file from checkpoint: {}, {}", (Object)sourceHandle, (Object)targetPath);
        String key = sourceHandle.getStreamStateHandleID().toString();
        this.getForStFlinkFileSystem().registerReusedRestoredFile(key, sourceHandle, targetPath);
        this.getForStFlinkFileSystem().link(key, targetPath);
    }

    @Override
    public String toString() {
        return "ReusableDataTransferStrategy{dbFileSystem=" + String.valueOf(this.dbFileSystem) + "}";
    }
}

