/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.forst;

import java.io.Closeable;
import java.math.BigInteger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import org.apache.flink.annotation.Internal;
import org.apache.flink.metrics.Gauge;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.metrics.View;
import org.apache.flink.state.forst.ForStNativeMetricOptions;
import org.apache.flink.state.forst.ForStProperty;
import org.forstdb.ColumnFamilyHandle;
import org.forstdb.RocksDB;
import org.forstdb.Statistics;
import org.forstdb.TickerType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class ForStNativeMetricMonitor
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(ForStNativeMetricMonitor.class);
    private final ForStNativeMetricOptions options;
    private final MetricGroup metricGroup;
    private final Object lock;
    static final String COLUMN_FAMILY_KEY = "column_family";
    @GuardedBy(value="lock")
    private RocksDB rocksDB;
    @Nullable
    @GuardedBy(value="lock")
    private Statistics statistics;

    public ForStNativeMetricMonitor(@Nonnull ForStNativeMetricOptions options, @Nonnull MetricGroup metricGroup, @Nonnull RocksDB rocksDB, @Nullable Statistics statistics) {
        this.options = options;
        this.metricGroup = metricGroup;
        this.rocksDB = rocksDB;
        this.statistics = statistics;
        this.lock = new Object();
        this.registerStatistics();
    }

    private void registerStatistics() {
        if (this.statistics != null) {
            for (TickerType tickerType : this.options.getMonitorTickerTypes()) {
                this.metricGroup.gauge(String.format("rocksdb.%s", tickerType.name().toLowerCase()), (Gauge)new ForStNativeStatisticsMetricView(tickerType));
            }
        }
    }

    void registerColumnFamily(String columnFamilyName, ColumnFamilyHandle handle) {
        boolean columnFamilyAsVariable = this.options.isColumnFamilyAsVariable();
        MetricGroup group = columnFamilyAsVariable ? this.metricGroup.addGroup(COLUMN_FAMILY_KEY, columnFamilyName) : this.metricGroup.addGroup(columnFamilyName);
        for (ForStProperty property : this.options.getProperties()) {
            ForStNativePropertyMetricView gauge = new ForStNativePropertyMetricView(handle, property);
            group.gauge(property.getForStProperty(), (Gauge)gauge);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setProperty(ForStNativePropertyMetricView metricView) {
        if (metricView.isClosed()) {
            return;
        }
        try {
            Object object = this.lock;
            synchronized (object) {
                if (this.rocksDB != null) {
                    long value = metricView.property.getNumericalPropertyValue(this.rocksDB, metricView.handle);
                    metricView.setValue(value);
                }
            }
        }
        catch (Exception e) {
            metricView.close();
            LOG.warn("Failed to read native metric {} from ForSt.", (Object)metricView.property, (Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setStatistics(ForStNativeStatisticsMetricView metricView) {
        if (metricView.isClosed()) {
            return;
        }
        if (this.statistics != null) {
            Object object = this.lock;
            synchronized (object) {
                metricView.setValue(this.statistics.getTickerCount(metricView.tickerType));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            this.rocksDB = null;
            this.statistics = null;
        }
    }

    class ForStNativeStatisticsMetricView
    extends ForStNativeView
    implements Gauge<Long> {
        private final TickerType tickerType;
        private long value;

        private ForStNativeStatisticsMetricView(TickerType tickerType) {
            this.tickerType = tickerType;
        }

        public Long getValue() {
            return this.value;
        }

        void setValue(long value) {
            this.value = value;
        }

        public void update() {
            ForStNativeMetricMonitor.this.setStatistics(this);
        }
    }

    class ForStNativePropertyMetricView
    extends ForStNativeView
    implements Gauge<BigInteger> {
        private final ForStProperty property;
        private final ColumnFamilyHandle handle;
        private BigInteger bigInteger;

        private ForStNativePropertyMetricView(@Nonnull ColumnFamilyHandle handle, ForStProperty property) {
            this.handle = handle;
            this.property = property;
            this.bigInteger = BigInteger.ZERO;
        }

        public void setValue(long value) {
            if (value >= 0L) {
                this.bigInteger = BigInteger.valueOf(value);
            } else {
                int upper = (int)(value >>> 32);
                int lower = (int)value;
                this.bigInteger = BigInteger.valueOf(Integer.toUnsignedLong(upper)).shiftLeft(32).add(BigInteger.valueOf(Integer.toUnsignedLong(lower)));
            }
        }

        public BigInteger getValue() {
            return this.bigInteger;
        }

        public void update() {
            ForStNativeMetricMonitor.this.setProperty(this);
        }
    }

    static abstract class ForStNativeView
    implements View {
        private boolean closed = false;

        ForStNativeView() {
        }

        void close() {
            this.closed = true;
        }

        boolean isClosed() {
            return this.closed;
        }
    }
}

