/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.forst.fs.cache;

import java.io.IOException;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import org.apache.flink.core.fs.FSDataInputStream;
import org.apache.flink.core.fs.FSDataOutputStream;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.asyncprocessing.ReferenceCounted;
import org.apache.flink.state.forst.fs.cache.CachedDataInputStream;
import org.apache.flink.state.forst.fs.cache.FileBasedCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FileCacheEntry
extends ReferenceCounted<Object> {
    private static final Logger LOG = LoggerFactory.getLogger(FileCacheEntry.class);
    private static final int READ_BUFFER_SIZE = 65536;
    final FileBasedCache fileBasedCache;
    final FileSystem cacheFs;
    final Path originalPath;
    final Path cachePath;
    final long entrySize;
    final Queue<CachedDataInputStream> openedStreams;
    final AtomicReference<EntryStatus> status;
    private Runnable touchFunction;
    long secondAccessEpoch = 0L;
    int accessCountInColdLink = 0;
    int evictCount = 0;

    FileCacheEntry(FileBasedCache fileBasedCache, Path originalPath, Path cachePath, long entrySize) {
        super(0);
        this.fileBasedCache = fileBasedCache;
        this.cacheFs = fileBasedCache.cacheFs;
        this.originalPath = originalPath;
        this.cachePath = cachePath;
        this.entrySize = entrySize;
        this.openedStreams = new LinkedBlockingQueue<CachedDataInputStream>();
        this.status = new AtomicReference<EntryStatus>(EntryStatus.REMOVED);
        LOG.trace("Create new cache entry {}.", (Object)cachePath);
    }

    public CachedDataInputStream open(FSDataInputStream originalStream) throws IOException {
        LOG.trace("Open new stream for cache entry {}.", (Object)this.cachePath);
        FSDataInputStream cacheStream = this.getCacheStream();
        if (cacheStream != null) {
            CachedDataInputStream inputStream = new CachedDataInputStream(this.fileBasedCache, this, cacheStream, originalStream);
            this.openedStreams.add(inputStream);
            this.release();
            return inputStream;
        }
        CachedDataInputStream inputStream = new CachedDataInputStream(this.fileBasedCache, this, originalStream);
        this.openedStreams.add(inputStream);
        return inputStream;
    }

    FSDataInputStream getCacheStream() throws IOException {
        if (this.status.get() == EntryStatus.LOADED && this.tryRetain() > 0) {
            return this.cacheFs.open(this.cachePath);
        }
        return null;
    }

    void setTouchFunction(Runnable touchFunction) {
        this.touchFunction = touchFunction;
    }

    void touch() {
        if (this.touchFunction != null) {
            this.touchFunction.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Path load() {
        FSDataInputStream inputStream = null;
        FSDataOutputStream outputStream = null;
        try {
            int maxReadBytes;
            int readBytes;
            byte[] buffer = new byte[65536];
            inputStream = this.originalPath.getFileSystem().open(this.originalPath, 65536);
            outputStream = this.cacheFs.create(this.cachePath, FileSystem.WriteMode.OVERWRITE);
            for (long maxTransferBytes = this.originalPath.getFileSystem().getFileStatus(this.originalPath).getLen(); maxTransferBytes > 0L && (readBytes = inputStream.read(buffer, 0, maxReadBytes = (int)Math.min(maxTransferBytes, 65536L))) != -1; maxTransferBytes -= (long)readBytes) {
                outputStream.write(buffer, 0, readBytes);
            }
            Path path = this.cachePath;
            return path;
        }
        catch (IOException e) {
            Path path = null;
            return path;
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    protected void referenceCountReachedZero(@Nullable Object o) {
        if (this.switchStatus(EntryStatus.INVALID, EntryStatus.REMOVING) || this.checkStatus(EntryStatus.CLOSED)) {
            this.fileBasedCache.removeFile(this);
        }
    }

    synchronized void doRemoveFile() {
        try {
            Iterator iterator = this.openedStreams.iterator();
            while (iterator.hasNext()) {
                CachedDataInputStream stream = (CachedDataInputStream)((Object)iterator.next());
                if (stream.isClosed()) {
                    iterator.remove();
                    continue;
                }
                stream.closeCachedStream();
            }
            this.cacheFs.delete(this.cachePath, false);
            if (this.status.get() != EntryStatus.CLOSED) {
                this.status.set(EntryStatus.REMOVED);
            }
        }
        catch (Exception e) {
            LOG.warn("Failed to delete cache entry {}.", (Object)this.cachePath, (Object)e);
        }
    }

    synchronized void loaded() {
        if (this.checkStatus(EntryStatus.LOADED)) {
            this.retain();
        }
    }

    synchronized boolean invalidate() {
        if (this.switchStatus(EntryStatus.LOADED, EntryStatus.INVALID)) {
            this.release();
            return true;
        }
        return false;
    }

    synchronized void close() {
        if (this.getAndSetStatus(EntryStatus.CLOSED) == EntryStatus.LOADED) {
            this.release();
        } else {
            this.status.set(EntryStatus.CLOSED);
        }
    }

    boolean switchStatus(EntryStatus from, EntryStatus to) {
        if (this.status.compareAndSet(from, to)) {
            LOG.trace("Cache {} (for {}) Switch status from {} to {}.", new Object[]{this.originalPath, this.cachePath, from, to});
            return true;
        }
        return false;
    }

    boolean checkStatus(EntryStatus to) {
        return this.status.get() == to;
    }

    EntryStatus getAndSetStatus(EntryStatus to) {
        return this.status.getAndSet(to);
    }

    public static enum EntryStatus {
        LOADED,
        LOADING,
        INVALID,
        REMOVING,
        REMOVED,
        CLOSED;

    }
}

