/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.forst;

import java.io.IOException;
import org.apache.flink.core.asyncprocessing.InternalAsyncFuture;
import org.apache.flink.state.forst.ContextKey;
import org.apache.flink.state.forst.ForStDBGetRequest;
import org.apache.flink.state.forst.ForStDBIterRequest;
import org.apache.flink.state.forst.ForStInnerTable;
import org.apache.flink.state.forst.ForStMapState;
import org.forstdb.RocksDB;
import org.forstdb.RocksDBException;
import org.forstdb.RocksIterator;

public class ForStDBMapCheckRequest<K, N, V>
extends ForStDBGetRequest<K, N, V, Boolean> {
    private static final byte[] VALID_PLACEHOLDER = new byte[0];
    private final int keyGroupPrefixBytes;
    private final boolean checkEmpty;

    public ForStDBMapCheckRequest(ContextKey<K, N> key, ForStInnerTable<K, N, V> table, InternalAsyncFuture<Boolean> future, boolean checkEmpty) {
        super(key, table, future);
        this.keyGroupPrefixBytes = ((ForStMapState)table).getKeyGroupPrefixBytes();
        this.checkEmpty = checkEmpty;
    }

    @Override
    public void process(RocksDB db) throws RocksDBException, IOException {
        byte[] key = this.buildSerializedKey();
        if (this.checkEmpty) {
            try (RocksIterator iter = db.newIterator(this.getColumnFamilyHandle());){
                iter.seek(key);
                if (iter.isValid() && ForStDBIterRequest.startWithKeyPrefix(key, iter.key(), this.keyGroupPrefixBytes)) {
                    this.completeStateFuture(VALID_PLACEHOLDER);
                }
                this.completeStateFuture(null);
            }
        } else {
            byte[] value = db.get(this.getColumnFamilyHandle(), key);
            this.completeStateFuture(value);
        }
    }

    @Override
    public void completeStateFuture(byte[] bytesValue) {
        if (this.checkEmpty) {
            this.future.complete((Object)(bytesValue == null ? 1 : 0));
            return;
        }
        this.future.complete((Object)(bytesValue != null ? 1 : 0));
    }
}

