/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.forst;

import java.io.IOException;
import javax.annotation.Nullable;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.core.state.InternalStateFuture;
import org.apache.flink.state.forst.ContextKey;
import org.apache.flink.state.forst.ForStDBWriteBatchWrapper;
import org.apache.flink.state.forst.ForStInnerTable;
import org.forstdb.ColumnFamilyHandle;
import org.forstdb.RocksDB;
import org.forstdb.RocksDBException;

public class ForStDBPutRequest<K, N, V> {
    final ContextKey<K, N> key;
    @Nullable
    final V value;
    final boolean isMerge;
    final ForStInnerTable<K, N, V> table;
    final InternalStateFuture<Void> future;

    ForStDBPutRequest(ContextKey<K, N> key, V value, boolean isMerge, ForStInnerTable<K, N, V> table, InternalStateFuture<Void> future) {
        this.key = key;
        this.value = value;
        this.isMerge = isMerge;
        this.table = table;
        this.future = future;
    }

    public void process(ForStDBWriteBatchWrapper writeBatchWrapper, RocksDB db) throws IOException, RocksDBException {
        if (this.value == null) {
            writeBatchWrapper.remove(this.table.getColumnFamilyHandle(), this.buildSerializedKey());
        } else if (this.isMerge) {
            writeBatchWrapper.merge(this.table.getColumnFamilyHandle(), this.buildSerializedKey(), this.buildSerializedValue());
        } else {
            writeBatchWrapper.put(this.table.getColumnFamilyHandle(), this.buildSerializedKey(), this.buildSerializedValue());
        }
    }

    public byte[] buildSerializedKey() throws IOException {
        return this.table.serializeKey(this.key);
    }

    public byte[] buildSerializedValue() throws IOException {
        assert (this.value != null);
        return this.table.serializeValue(this.value);
    }

    public void completeStateFuture() {
        this.future.complete(null);
    }

    public void completeStateFutureExceptionally(String message, Throwable ex) {
        this.future.completeExceptionally(message, ex);
    }

    static <K, N, V> ForStDBPutRequest<K, N, V> of(ContextKey<K, N> key, @Nullable V value, ForStInnerTable<K, N, V> table, InternalStateFuture<Void> future) {
        return new ForStDBPutRequest<K, N, V>(key, value, false, table, future);
    }

    static <K, N, V> ForStDBPutRequest<K, N, V> ofMerge(ContextKey<K, N> key, @Nullable V value, ForStInnerTable<K, N, V> table, InternalStateFuture<Void> future) {
        return new ForStDBPutRequest<K, N, V>(key, value, true, table, future);
    }

    @VisibleForTesting
    public boolean valueIsNull() {
        return this.value == null;
    }

    @VisibleForTesting
    public ColumnFamilyHandle getColumnFamilyHandle() {
        return this.table.getColumnFamilyHandle();
    }
}

