/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.changelog;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.apache.flink.api.common.state.State;
import org.apache.flink.api.common.typeutils.base.ListSerializer;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.runtime.state.InternalKeyContext;
import org.apache.flink.runtime.state.internal.InternalKvState;
import org.apache.flink.runtime.state.internal.InternalListState;
import org.apache.flink.state.changelog.AbstractChangelogState;
import org.apache.flink.state.changelog.KvStateChangeLogger;
import org.apache.flink.state.changelog.restore.ChangelogApplierFactory;
import org.apache.flink.state.changelog.restore.StateChangeApplier;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.function.ThrowingConsumer;

class ChangelogListState<K, N, V>
extends AbstractChangelogState<K, N, List<V>, InternalListState<K, N, V>>
implements InternalListState<K, N, V> {
    private final InternalKeyContext<K> keyContext;

    ChangelogListState(InternalListState<K, N, V> delegatedState, KvStateChangeLogger<List<V>, N> changeLogger, InternalKeyContext<K> keyContext) {
        super(delegatedState, changeLogger);
        this.keyContext = keyContext;
    }

    public void update(List<V> values) throws Exception {
        ((InternalListState)this.delegatedState).update(values);
        this.changeLogger.valueUpdated(values, this.getCurrentNamespace());
    }

    public void addAll(List<V> values) throws Exception {
        ((InternalListState)this.delegatedState).addAll(values);
        this.changeLogger.valueAdded(values, this.getCurrentNamespace());
    }

    public void updateInternal(List<V> valueToStore) throws Exception {
        ((InternalListState)this.delegatedState).updateInternal(valueToStore);
        this.changeLogger.valueUpdatedInternal(valueToStore, this.getCurrentNamespace());
    }

    public void add(V value) throws Exception {
        ((InternalListState)this.delegatedState).add(value);
        this.changeLogger.valueElementAdded((ThrowingConsumer<DataOutputView, IOException>)((ThrowingConsumer)w -> ((ListSerializer)this.getValueSerializer()).getElementSerializer().serialize(value, w)), this.getCurrentNamespace());
    }

    public void mergeNamespaces(N target, Collection<N> sources) throws Exception {
        ((InternalListState)this.delegatedState).mergeNamespaces(target, sources);
        this.changeLogger.namespacesMerged(target, sources);
    }

    public List<V> getInternal() throws Exception {
        return (List)((InternalListState)this.delegatedState).getInternal();
    }

    public Iterable<V> get() throws Exception {
        return (Iterable)((InternalListState)this.delegatedState).get();
    }

    public void clear() {
        ((InternalListState)this.delegatedState).clear();
        try {
            this.changeLogger.valueCleared(this.getCurrentNamespace());
        }
        catch (IOException e) {
            ExceptionUtils.rethrow((Throwable)e);
        }
    }

    static <K, N, SV, S extends State, IS extends S> IS create(InternalKvState<K, N, SV> listState, KvStateChangeLogger<SV, N> changeLogger, InternalKeyContext<K> keyContext) {
        return (IS)new ChangelogListState((InternalListState)listState, changeLogger, keyContext);
    }

    @Override
    public StateChangeApplier getChangeApplier(ChangelogApplierFactory factory) {
        return factory.forList((InternalListState)this.delegatedState, this.keyContext);
    }
}

