/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.api.input;

import java.io.IOException;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.state.ListStateDescriptor;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.checkpoint.OperatorState;
import org.apache.flink.runtime.state.OperatorStateBackend;
import org.apache.flink.runtime.state.StateBackend;
import org.apache.flink.state.api.input.OperatorStateInputFormat;
import org.apache.flink.util.Preconditions;

@Internal
public class UnionStateInputFormat<OT>
extends OperatorStateInputFormat<OT> {
    private static final long serialVersionUID = 499388405631162440L;
    private final ListStateDescriptor<OT> descriptor;

    public UnionStateInputFormat(OperatorState operatorState, Configuration configuration, @Nullable StateBackend backend, ListStateDescriptor<OT> descriptor, ExecutionConfig executionConfig) throws IOException {
        super(operatorState, configuration, backend, true, executionConfig);
        this.descriptor = (ListStateDescriptor)Preconditions.checkNotNull(descriptor, (String)"The state descriptor must not be null");
    }

    @Override
    protected final Iterable<OT> getElements(OperatorStateBackend restoredBackend) throws Exception {
        return (Iterable)restoredBackend.getUnionListState(this.descriptor).get();
    }
}

